/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile;

import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.Node;
import com.lintyservices.sonar.plugins.vhdl.parser.ArrayTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ElementDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.NameTree;
import com.lintyservices.sonar.plugins.vhdl.parser.RecordTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import java.util.List;

public class TypeAndSubtypeTreeFileUtils {
    private TypeAndSubtypeTreeFileUtils() {
    }

    public static void buildNameTree(Node<GenericTreeFile<NameTree>> node, List<TypeTreeFile> arrayTypes, List<TypeTreeFile> recordTypes, List<SubtypeTreeFile> subtypes) {
        NameTree childNameTree;
        String type = ((NameTree)node.getData().tree()).firstToken().text().toLowerCase();
        TypeTreeFile relatedRecordTypeTreeFile = recordTypes.stream().filter(tf -> ((FullTypeDeclarationTree)tf.tree()).identifier().text().equalsIgnoreCase(type)).findFirst().orElse(null);
        TypeTreeFile relatedArrayTypeTreeFile = arrayTypes.stream().filter(tf -> ((FullTypeDeclarationTree)tf.tree()).identifier().text().equalsIgnoreCase(type)).findFirst().orElse(null);
        SubtypeTreeFile relatedSubtypeTreeFile = subtypes.stream().filter(tf -> ((SubtypeDeclarationTree)tf.tree()).identifier().text().equalsIgnoreCase(type)).findFirst().orElse(null);
        if (relatedRecordTypeTreeFile != null) {
            List<ElementDeclarationTree> declarations = ((RecordTypeDefinitionTree)((FullTypeDeclarationTree)relatedRecordTypeTreeFile.tree()).typeDefinition()).elementDeclarations();
            for (ElementDeclarationTree declaration : declarations) {
                NameTree childNameTree2 = declaration.subtypeDefinition().typeName();
                Node<GenericTreeFile<NameTree>> child = new Node<GenericTreeFile<NameTree>>(new GenericTreeFile<NameTree>(childNameTree2, relatedRecordTypeTreeFile.file()));
                node.addChild(child);
                TypeAndSubtypeTreeFileUtils.buildNameTree(child, arrayTypes, recordTypes, subtypes);
            }
        } else if (relatedArrayTypeTreeFile != null) {
            NameTree childNameTree3 = ((ArrayTypeDefinitionTree)((FullTypeDeclarationTree)relatedArrayTypeTreeFile.tree()).typeDefinition()).subtypeIndication().typeName();
            Node<GenericTreeFile<NameTree>> child = new Node<GenericTreeFile<NameTree>>(new GenericTreeFile<NameTree>(childNameTree3, relatedArrayTypeTreeFile.file()));
            node.addChild(child);
            TypeAndSubtypeTreeFileUtils.buildNameTree(child, arrayTypes, recordTypes, subtypes);
        } else if (relatedSubtypeTreeFile != null && (childNameTree = ((SubtypeDeclarationTree)relatedSubtypeTreeFile.tree()).subtypeIndication().typeName()) != null) {
            Node<GenericTreeFile<NameTree>> child = new Node<GenericTreeFile<NameTree>>(new GenericTreeFile<NameTree>(childNameTree, relatedSubtypeTreeFile.file()));
            node.addChild(child);
            TypeAndSubtypeTreeFileUtils.buildNameTree(child, arrayTypes, recordTypes, subtypes);
        }
    }
}

