/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlPunctuator;
import java.util.Map;
import org.sonar.sslr.grammar.GrammarRuleKey;

public final class KindMaps {
    private final Map<GrammarRuleKey, VhdlTree.Kind> binaryOperators;

    public KindMaps() {
        ImmutableMap.Builder<Enum, VhdlTree.Kind> binaryOperatorsBuilder = ImmutableMap.builder();
        binaryOperatorsBuilder.put(VhdlKeyword.AND, VhdlTree.Kind.AND);
        binaryOperatorsBuilder.put(VhdlKeyword.OR, VhdlTree.Kind.OR);
        binaryOperatorsBuilder.put(VhdlKeyword.NAND, VhdlTree.Kind.NAND);
        binaryOperatorsBuilder.put(VhdlKeyword.NOR, VhdlTree.Kind.NOR);
        binaryOperatorsBuilder.put(VhdlKeyword.XOR, VhdlTree.Kind.XOR);
        binaryOperatorsBuilder.put(VhdlKeyword.XNOR, VhdlTree.Kind.XNOR);
        binaryOperatorsBuilder.put(VhdlPunctuator.EQUAL, VhdlTree.Kind.EQUAL);
        binaryOperatorsBuilder.put(VhdlPunctuator.NOTEQ, VhdlTree.Kind.NOTEQ);
        binaryOperatorsBuilder.put(VhdlPunctuator.LT, VhdlTree.Kind.LT);
        binaryOperatorsBuilder.put(VhdlPunctuator.LE, VhdlTree.Kind.LE);
        binaryOperatorsBuilder.put(VhdlPunctuator.GT, VhdlTree.Kind.GT);
        binaryOperatorsBuilder.put(VhdlPunctuator.GE, VhdlTree.Kind.GE);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHEQUAL, VhdlTree.Kind.MTCHEQUAL);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHNOTEQ, VhdlTree.Kind.MTCHNOTEQ);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHLT, VhdlTree.Kind.MTCHLT);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHLE, VhdlTree.Kind.MTCHLE);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHGT, VhdlTree.Kind.MTCHGT);
        binaryOperatorsBuilder.put(VhdlPunctuator.MTCHGE, VhdlTree.Kind.MTCHGE);
        binaryOperatorsBuilder.put(VhdlKeyword.SLL, VhdlTree.Kind.SLL);
        binaryOperatorsBuilder.put(VhdlKeyword.SRL, VhdlTree.Kind.SRL);
        binaryOperatorsBuilder.put(VhdlKeyword.SLA, VhdlTree.Kind.SLA);
        binaryOperatorsBuilder.put(VhdlKeyword.SRA, VhdlTree.Kind.SRA);
        binaryOperatorsBuilder.put(VhdlKeyword.ROL, VhdlTree.Kind.ROL);
        binaryOperatorsBuilder.put(VhdlKeyword.ROR, VhdlTree.Kind.ROR);
        binaryOperatorsBuilder.put(VhdlPunctuator.PLUS, VhdlTree.Kind.PLUS);
        binaryOperatorsBuilder.put(VhdlPunctuator.MINUS, VhdlTree.Kind.MINUS);
        binaryOperatorsBuilder.put(VhdlPunctuator.CONCA, VhdlTree.Kind.CONCA);
        binaryOperatorsBuilder.put(VhdlPunctuator.STAR, VhdlTree.Kind.STAR);
        binaryOperatorsBuilder.put(VhdlPunctuator.DIV, VhdlTree.Kind.DIV);
        binaryOperatorsBuilder.put(VhdlKeyword.MOD, VhdlTree.Kind.MOD);
        binaryOperatorsBuilder.put(VhdlKeyword.REM, VhdlTree.Kind.REM);
        binaryOperatorsBuilder.put(VhdlPunctuator.DTAR, VhdlTree.Kind.DTAR);
        this.binaryOperators = binaryOperatorsBuilder.build();
    }

    public VhdlTree.Kind getBinaryOperator(GrammarRuleKey ruleKey) {
        return Preconditions.checkNotNull(this.binaryOperators.get(ruleKey), "Mapping not found for binary operator %s", (Object)ruleKey);
    }
}

