/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.model;

import com.google.common.base.Objects;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(List<? extends VhdlTree> leftList, List<? extends VhdlTree> rightList) {
        if (leftList.size() != rightList.size()) {
            return false;
        }
        for (int i = 0; i < leftList.size(); ++i) {
            VhdlTree right;
            VhdlTree left = leftList.get(i);
            if (SyntacticEquivalence.areEquivalent(left, right = rightList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable VhdlTree leftNode, @Nullable VhdlTree rightNode) {
        return SyntacticEquivalence.areEquivalent((TreeImpl)leftNode, (TreeImpl)rightNode);
    }

    private static boolean areEquivalent(@Nullable TreeImpl leftNode, @Nullable TreeImpl rightNode) {
        if (leftNode == rightNode) {
            return true;
        }
        if (leftNode == null || rightNode == null) {
            return false;
        }
        if (leftNode.kind() != rightNode.kind()) {
            return false;
        }
        if (leftNode.isLeaf()) {
            return SyntacticEquivalence.areLeafsEquivalent(leftNode, rightNode);
        }
        Iterator<VhdlTree> iteratorA = leftNode.getChildren().iterator();
        Iterator<VhdlTree> iteratorB = rightNode.getChildren().iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (SyntacticEquivalence.areEquivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    private static boolean areLeafsEquivalent(TreeImpl leftNode, TreeImpl rightNode) {
        if (leftNode instanceof IdentifierTree) {
            return Objects.equal(((IdentifierTree)((Object)leftNode)).text(), ((IdentifierTree)((Object)rightNode)).text());
        }
        if (leftNode instanceof VhdlSyntaxToken) {
            return Objects.equal(((VhdlSyntaxToken)((Object)leftNode)).text(), ((VhdlSyntaxToken)((Object)rightNode)).text());
        }
        throw new IllegalArgumentException();
    }
}

