/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.BinaryExpressionTree;

public class BinaryExpressionTreeImpl
extends TreeImpl
implements BinaryExpressionTree {
    private final VhdlTree.Kind kind;
    private final VhdlTree leftOperand;
    private final VhdlInternalSyntaxToken operator;
    private final VhdlTree rightOperand;

    public BinaryExpressionTreeImpl(VhdlTree.Kind kind, VhdlTree leftOperand, VhdlInternalSyntaxToken operator, VhdlTree rightOperand) {
        super(kind);
        this.kind = Preconditions.checkNotNull(kind);
        this.leftOperand = Preconditions.checkNotNull(leftOperand);
        this.operator = operator;
        this.rightOperand = Preconditions.checkNotNull(rightOperand);
    }

    @Override
    public VhdlTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public VhdlSyntaxToken operatorToken() {
        return this.operator;
    }

    @Override
    public VhdlTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public VhdlTree.Kind kind() {
        return this.kind;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public Iterable<VhdlTree> children() {
        return Lists.newArrayList(this.leftOperand, this.operator, this.rightOperand);
    }
}

