/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ArchitectureBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ConfigurationDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignUnitTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageDeclarationTree;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DesignFileTreeImpl
extends TreeImpl
implements DesignFileTree {
    private final List<DesignUnitTree> units;
    private final VhdlInternalSyntaxToken eofToken;

    public DesignFileTreeImpl(List<DesignUnitTree> units, VhdlInternalSyntaxToken eofToken) {
        super(VhdlTree.Kind.DESIGN_FILE);
        this.units = units;
        this.eofToken = eofToken;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDesignFile(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.DESIGN_FILE;
    }

    @Override
    public List<DesignUnitTree> units() {
        return this.units;
    }

    @Override
    public List<ConfigurationDeclarationTree> configurations() {
        return this.units.stream().map(DesignUnitTree::libraryUnit).filter(l -> l.is(VhdlTree.Kind.CONFIGURATION_DECLARATION)).map(ConfigurationDeclarationTree.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<EntityDeclarationTree> entities() {
        return this.units.stream().map(DesignUnitTree::libraryUnit).filter(l -> l.is(VhdlTree.Kind.ENTITY_DECLARATION)).map(EntityDeclarationTree.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<ArchitectureBodyTree> architectures() {
        return this.units.stream().map(DesignUnitTree::libraryUnit).filter(l -> l.is(VhdlTree.Kind.ARCHITECTURE_BODY)).map(ArchitectureBodyTree.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<PackageDeclarationTree> packages() {
        return this.units.stream().map(DesignUnitTree::libraryUnit).filter(l -> l.is(VhdlTree.Kind.PACKAGE_DECLARATION)).map(PackageDeclarationTree.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<PackageBodyTree> packageBodies() {
        return this.units.stream().map(DesignUnitTree::libraryUnit).filter(l -> l.is(VhdlTree.Kind.PACKAGE_BODY)).map(PackageBodyTree.class::cast).collect(Collectors.toList());
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(this.units, Collections.singleton(this.eofToken));
    }

    @Override
    public VhdlSyntaxToken eofToken() {
        return this.eofToken;
    }
}

