/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarativePartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityHeaderTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityStatementPartTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityStatementPartTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class EntityDeclarationTreeImpl
extends TreeImpl
implements EntityDeclarationTree {
    private final VhdlInternalSyntaxToken beginEntityKeyword;
    private final IdentifierTree identifier;
    private final VhdlInternalSyntaxToken isKeyword;
    @Nullable
    private final EntityHeaderTree header;
    private final EntityDeclarativePartTree declarativePart;
    @Nullable
    private final EntityStatementPartTree statements;
    @Nullable
    private final VhdlInternalSyntaxToken beginKeyword;
    private final VhdlInternalSyntaxToken endKeyword;
    @Nullable
    private final VhdlInternalSyntaxToken endEntityKeyword;
    private final IdentifierTree endIdentifier;
    private final VhdlInternalSyntaxToken semiPunc;

    public EntityDeclarationTreeImpl(VhdlInternalSyntaxToken beginEntityKeyword, IdentifierTreeImpl identifierTreeImpl, VhdlInternalSyntaxToken isKeyword, Optional<EntityHeaderTree> headerTree, Optional<EntityDeclarativePartTree> declarativePartTree, VhdlInternalSyntaxToken beginKeyword, EntityStatementPartTree statements, VhdlInternalSyntaxToken endKeyword, Optional<VhdlInternalSyntaxToken> endEntityKeyword, IdentifierTreeImpl endIdentifier, VhdlInternalSyntaxToken semicolon) {
        super(VhdlTree.Kind.ENTITY_DECLARATION);
        this.beginEntityKeyword = beginEntityKeyword;
        this.identifier = identifierTreeImpl;
        this.isKeyword = isKeyword;
        this.header = headerTree.isPresent() ? headerTree.get() : null;
        this.declarativePart = declarativePartTree.isPresent() ? declarativePartTree.get() : null;
        this.beginKeyword = beginKeyword;
        this.statements = statements == null ? new EntityStatementPartTreeImpl(Collections.emptyList()) : statements;
        this.endKeyword = endKeyword;
        this.endEntityKeyword = endEntityKeyword.isPresent() ? endEntityKeyword.get() : null;
        this.endIdentifier = endIdentifier;
        this.semiPunc = semicolon;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitEntityDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.ENTITY_DECLARATION;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.beginEntityKeyword), Collections.singleton(this.identifier), Collections.singleton(this.isKeyword), this.header != null ? Collections.singleton(this.header) : Collections.emptyList(), this.declarativePart != null ? Collections.singleton(this.declarativePart) : Collections.emptyList(), Collections.singleton(this.beginKeyword), Collections.singleton(this.statements), Collections.singleton(this.endKeyword), this.endEntityKeyword != null ? Collections.singleton(this.endEntityKeyword) : Collections.emptyList(), this.endIdentifier != null ? Collections.singleton(this.endIdentifier) : Collections.emptyList(), Collections.singleton(this.semiPunc));
    }

    @Override
    public VhdlInternalSyntaxToken beginEntityKeyword() {
        return this.beginEntityKeyword;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public EntityHeaderTree header() {
        return this.header;
    }

    @Override
    public EntityDeclarativePartTree declarativePart() {
        return this.declarativePart;
    }

    @Override
    public EntityStatementPartTree statements() {
        return this.statements;
    }

    @Override
    public String humanReadableKind() {
        return "entity";
    }

    @Override
    @Nullable
    public IdentifierTree endIdentifier() {
        return this.endIdentifier;
    }

    @Override
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    public Set<IdentifierTree> outputPortIdentifiers() {
        return this.portIdentifiers(VhdlKeyword.OUT);
    }

    @Override
    public Set<IdentifierTree> inputPortIdentifiers() {
        return this.portIdentifiers(VhdlKeyword.IN);
    }

    @Override
    public Set<IdentifierTree> allPortIdentifiers() {
        return this.portIdentifiers(null);
    }

    @Override
    public Set<IdentifierTree> genericIdentifiers() {
        HashSet<IdentifierTree> genericIdentifiers = new HashSet<IdentifierTree>();
        if (this.header != null && this.header.genericClause() != null) {
            List<InterfaceDeclarationTree> genericDeclarations = this.header.genericClause().generics().interfaces();
            for (InterfaceDeclarationTree genericDeclaration : genericDeclarations) {
                genericIdentifiers.addAll(genericDeclaration.identifiers());
            }
        }
        return genericIdentifiers;
    }

    @Override
    public List<InterfaceDeclarationTree> generics() {
        if (this.header != null && this.header.genericClause() != null) {
            return this.header.genericClause().generics().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    @Override
    public List<InterfaceDeclarationTree> ports() {
        if (this.header != null && this.header.portClause() != null) {
            return this.header.portClause().ports().interfaces();
        }
        return new ArrayList<InterfaceDeclarationTree>();
    }

    @Override
    public Set<IdentifierTree> portIdentifiers() {
        return this.portIdentifiers(null);
    }

    private Set<IdentifierTree> portIdentifiers(@Nullable GrammarRuleKey mode) {
        HashSet<IdentifierTree> portIdentifiers = new HashSet<IdentifierTree>();
        if (this.header != null && this.header.portClause() != null) {
            List<InterfaceDeclarationTree> portDeclarations = this.header.portClause().ports().interfaces();
            for (InterfaceDeclarationTree portDeclaration : portDeclarations) {
                if (mode != null && (portDeclaration.mode() == null || portDeclaration.mode().getGrammarRuleKey() != mode)) continue;
                portIdentifiers.addAll(portDeclaration.identifiers());
            }
        }
        return portIdentifiers;
    }
}

