/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.GenericClauseTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceListTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GenericClauseTreeImpl
extends TreeImpl
implements GenericClauseTree {
    private final VhdlInternalSyntaxToken genericKeyword;
    private final VhdlInternalSyntaxToken lparToken;
    private final InterfaceListTree generics;
    private final VhdlInternalSyntaxToken rparToken;
    private final VhdlInternalSyntaxToken semiPunc;

    public GenericClauseTreeImpl(VhdlInternalSyntaxToken genericKeyword, VhdlInternalSyntaxToken lparToken, InterfaceListTree generics, VhdlInternalSyntaxToken rparToken, VhdlInternalSyntaxToken semiPunc) {
        super(VhdlTree.Kind.GENERIC_CLAUSE);
        this.genericKeyword = genericKeyword;
        this.lparToken = lparToken;
        this.generics = generics;
        this.rparToken = rparToken;
        this.semiPunc = semiPunc;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitGenericClause(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.GENERIC_CLAUSE;
    }

    @Override
    public VhdlInternalSyntaxToken genericKeyword() {
        return this.genericKeyword;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.genericKeyword), Collections.singleton(this.lparToken), Collections.singleton(this.generics), Collections.singleton(this.rparToken), Collections.singleton(this.semiPunc));
    }

    @Override
    public InterfaceListTree generics() {
        return this.generics;
    }

    @Override
    public List<IdentifierTree> identifiers() {
        ArrayList<IdentifierTree> identifiers = new ArrayList<IdentifierTree>();
        for (InterfaceDeclarationTree tree : this.generics.interfaces()) {
            if (tree.identifiers() == null) continue;
            identifiers.addAll(tree.identifiers());
        }
        return identifiers;
    }

    @Override
    public String humanReadableKind() {
        return "generic parameter";
    }
}

