/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.ConstantDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyDeclarativeItemTree;
import com.lintyservices.sonar.plugins.vhdl.parser.PackageBodyTree;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PackageBodyTreeImpl
extends TreeImpl
implements PackageBodyTree {
    private final VhdlInternalSyntaxToken packageKeyword;
    private final VhdlInternalSyntaxToken bodyKeyword;
    private final IdentifierTree identifier;
    private final VhdlInternalSyntaxToken isKeyword;
    private final List<PackageBodyDeclarativeItemTree> declarativeItems;
    private final VhdlInternalSyntaxToken endKeyword;
    @Nullable
    private final VhdlInternalSyntaxToken packageKeyword2;
    @Nullable
    private final VhdlInternalSyntaxToken bodyKeyword2;
    @Nullable
    private final IdentifierTree endIdentifier;
    private final VhdlInternalSyntaxToken semiPunc;
    private final Set<ConstantDeclarationTree> initializedConstants;

    public PackageBodyTreeImpl(VhdlInternalSyntaxToken packageKeyword, VhdlInternalSyntaxToken bodyKeyword, IdentifierTree identifier, VhdlInternalSyntaxToken isKeyword, List<PackageBodyDeclarativeItemTree> declarativeItems, VhdlInternalSyntaxToken endKeyword, @Nullable VhdlInternalSyntaxToken packageKeyword2, @Nullable VhdlInternalSyntaxToken bodyKeyword2, @Nullable IdentifierTree endIdentifier, VhdlInternalSyntaxToken semicolon) {
        super(VhdlTree.Kind.PACKAGE_BODY);
        this.packageKeyword = packageKeyword;
        this.bodyKeyword = bodyKeyword;
        this.identifier = identifier;
        this.isKeyword = isKeyword;
        this.declarativeItems = declarativeItems;
        this.endKeyword = endKeyword;
        this.packageKeyword2 = packageKeyword2;
        this.bodyKeyword2 = bodyKeyword2;
        this.endIdentifier = endIdentifier;
        this.semiPunc = semicolon;
        this.initializedConstants = declarativeItems.stream().filter(t -> t.is(VhdlTree.Kind.CONSTANT_DECLARATION)).map(ConstantDeclarationTree.class::cast).filter(t -> t.expression() != null).collect(Collectors.toSet());
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitPackageBody(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.PACKAGE_BODY;
    }

    @Override
    public VhdlInternalSyntaxToken packageKeyword() {
        return this.packageKeyword;
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public List<PackageBodyDeclarativeItemTree> declarativeItems() {
        return this.declarativeItems;
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.packageKeyword), Collections.singleton(this.bodyKeyword), Collections.singleton(this.identifier), Collections.singleton(this.isKeyword), this.declarativeItems, Collections.singleton(this.endKeyword), this.packageKeyword2 != null ? Collections.singleton(this.packageKeyword2) : Collections.emptyList(), this.bodyKeyword2 != null ? Collections.singleton(this.bodyKeyword2) : Collections.emptyList(), this.endIdentifier != null ? Collections.singleton(this.endIdentifier) : Collections.emptyList(), Collections.singleton(this.semiPunc));
    }

    @Override
    @Nullable
    public IdentifierTree endIdentifier() {
        return this.endIdentifier;
    }

    @Override
    public VhdlInternalSyntaxToken endKeyword() {
        return this.endKeyword;
    }

    @Override
    public Set<ConstantDeclarationTree> initializedConstants() {
        return this.initializedConstants;
    }

    @Override
    public String humanReadableKind() {
        return "package body";
    }
}

