/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Iterables;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTreeImpl;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubprogramSpecificationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.Collections;
import java.util.List;

public class SubprogramDeclarationTreeImpl
extends TreeImpl
implements SubprogramDeclarationTree {
    private final SubprogramSpecificationTree specification;
    private final VhdlSyntaxToken semicolon;

    public SubprogramDeclarationTreeImpl(SubprogramSpecificationTree specification, VhdlSyntaxToken semicolon) {
        super(VhdlTree.Kind.SUBPROGRAM_DECLARATION);
        this.specification = specification;
        this.semicolon = semicolon;
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitDeclaration(this);
        visitor.visitSubprogramDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public VhdlTree.Kind kind() {
        return VhdlTree.Kind.SUBPROGRAM_DECLARATION;
    }

    @Override
    public SubprogramSpecificationTree specification() {
        return this.specification;
    }

    @Override
    public IdentifierTree identifier() {
        return new IdentifierTreeImpl(this.specification.designator());
    }

    @Override
    protected Iterable<VhdlTree> children() {
        return Iterables.concat(Collections.singleton(this.specification), Collections.singleton(this.semicolon));
    }

    @Override
    public VhdlInternalSyntaxToken mode() {
        return null;
    }

    @Override
    public SubtypeIndicationTree type() {
        return null;
    }

    @Override
    public String humanReadableKind() {
        return "subprogram";
    }

    @Override
    public List<IdentifierTree> identifiers() {
        return Collections.emptyList();
    }
}

