/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlPunctuator;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlTokenType;
import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum VhdlLexer implements GrammarRuleKey
{
    SELECTED_NAME_COMMA_SEPARATED_LIST,
    USE_CLAUSE,
    ELSE_GENERATE_STATEMENT,
    ELSIF_GENERATE_STATEMENT,
    GENERATE_STATEMENT_BODY,
    GENERATE_STATEMENT_BODY_BLOCK,
    IF_GENERATE_STATEMENT,
    SPACING,
    LETTER_OR_DIGIT,
    SELECTED_NAME,
    SUFFIX,
    ENTITY_DECLARATION,
    ENTITY_HEADER,
    ENTITY_DECLARATIVE_PART,
    ENTITY_DECLARATIVE_ITEM,
    ENTITY_STATEMENT_PART,
    ENTITY_STATEMENT,
    ARCHITECTURE_BODY,
    ARCHITECTURE_DECLARATIVE_PART,
    BLOCK_DECLARATIVE_ITEM,
    ARCHITECTURE_STATEMENT_PART,
    PROCESS_STATEMENT,
    PROCESS_DECLARATIVE_PART,
    PROCESS_STATEMENT_PART,
    VARIABLE_DECLARATION,
    SUBTYPE_INDICATION,
    IDENTIFIER_LIST,
    SEQUENTIAL_STATEMENT,
    WAIT_STATEMENT,
    SENSITIVITY_CLAUSE,
    CONDITION_CLAUSE,
    TIMEOUT_CLAUSE,
    PROCEDURE_CALL_STATEMENT,
    PROCEDURE_CALL,
    ACTUAL_PARAMETER_PART,
    ASSOCIATION_LIST,
    ASSOCIATION_ELEMENT,
    ACTUAL_PART,
    ACTUAL_DESIGNATOR,
    KEYWORD,
    CONFIGURATION_DECLARATION,
    CONFIGURATION_DECLARATIVE_PART,
    CONFIGURATION_DECLARATIVE_ITEM,
    BLOCK_CONFIGURATION,
    CONFIGURATION_ITEM,
    DESIGN_FILE,
    DESIGN_UNIT,
    CONTEXT_CLAUSE,
    CONTEXT_ITEM,
    LIBRARY_UNIT,
    LIBRARY_CLAUSE,
    PRIMARY_UNIT,
    SECONDARY_UNIT,
    PACKAGE_DECLARATION,
    PACKAGE_BODY,
    SIMPLE_EXPRESSION,
    SIGN,
    TERM,
    ADDING_OPERATOR,
    FACTOR,
    MULTIPLYING_OPERATOR,
    PRIMARY,
    VARIABLE_ASSIGNMENT_STATEMENT,
    EXPRESSION,
    RELATION,
    SHIFT_EXPRESSION,
    SHIFT_OPERATOR,
    RELATIONAL_OPERATOR,
    SIGNAL_DECLARATION,
    SIGNAL_KIND,
    PORT_CLAUSE,
    GENERIC_CLAUSE,
    PORT_LIST,
    GENERIC_LIST,
    INTERFACE_LIST,
    INTERFACE_ELEMENT,
    INTERFACE_DECLARATION,
    INTERFACE_VARIABLE_DECLARATION,
    MODE,
    CONCURRENT_STATEMENT,
    SENSITIVITY_LIST,
    FUNCTION_CALL,
    CASE_STATEMENT,
    CASE_STATEMENT_ALTERNATIVE,
    CHOICES,
    CHOICE,
    SEQUENCE_OF_STATEMENTS,
    TYPE_DECLARATION,
    FULL_TYPE_DECLARATION,
    TYPE_DEFINITION,
    SCALAR_TYPE_DEFINITION,
    INTEGER_TYPE_DEFINITION,
    FLOATING_TYPE_DEFINITION,
    PHYSICAL_TYPE_DEFINITION,
    ENUMERATION_TYPE_DEFINITION,
    ENUMERATION_LITERAL,
    INCOMPLETE_TYPE_DECLARATION,
    IF_STATEMENT,
    CONDITION,
    IF_ELSIF_CONDITION,
    ELSIF_STATEMENT,
    CONSTRAINT,
    RANGE_CONSTRAINT,
    INDEX_CONSTRAINT,
    DISCRETE_RANGE,
    RANGE,
    DIRECTION,
    SIMPLE_WAVEFORM_SIGNAL_ASSIGNMENT_STATEMENT,
    SIMPLE_FORCE_SIGNAL_ASSIGNMENT_STATEMENT,
    SIMPLE_RELEASE_SIGNAL_ASSIGNMENT_STATEMENT,
    DELAY_MECHANISM,
    WAVEFORM,
    WAVEFORM_ELEMENT,
    LITERAL,
    NUMERIC_LITERAL,
    NULL_STATEMENT,
    CONCURRENT_SIGNAL_ASSIGNMENT_STATEMENT,
    SELECTED_FORCE_SIGNAL_ASSIGNMENT,
    SELECTED_WAVEFORM_SIGNAL_ASSIGNMENT,
    CONDITIONAL_SIGNAL_ASSIGNMENT,
    CONDITIONAL_WAVEFORMS,
    CONDITIONAL_WAVEFORMS_ELEMENT,
    OPTIONS,
    AGGREGATE,
    ELEMENT_ASSOCIATION,
    ASSERTION_STATEMENT,
    ASSERTION,
    CONCURRENT_ASSERTION_STATEMENT,
    PREFIX,
    NAME,
    SIMPLE_NAME,
    ATTRIBUTE_NAME,
    SIGNATURE,
    ATTRIBUTE_DESIGNATOR,
    INDEXED_NAME,
    INDEXED_NAME_EXPRESSIONS,
    SLICE_NAME,
    PROCESS_DECLARATIVE_ITEM,
    SUBPROGRAM_SPECIFICATION,
    SUBPROGRAM_SPECIFICATION_FUNCTION,
    SUBPROGRAM_SPECIFICATION_PROCEDURE,
    SUBPROGRAM_DECLARATION,
    SUBPROGRAM_BODY,
    SUBPROGRAM_DECLARATIVE_PART,
    SUBPROGRAM_DECLARATIVE_ITEM,
    SUBPROGRAM_STATEMENT_PART,
    SUBPROGRAM_KIND,
    RETURN_STATEMENT,
    CONSTANT_DECLARATION,
    PACKAGE_DECLARATIVE_PART,
    PACKAGE_DECLARATIVE_ITEM,
    ATTRIBUTE_DECLARATION,
    COMPONENT_DECLARATION,
    SUBTYPE_DECLARATION,
    GENERIC_MAP_ASPECT,
    PORT_MAP_ASPECT,
    COMPONENT_INSTANTIATION_STATEMENT,
    INSTANTIATED_UNIT,
    INSTANTIATED_UNIT_COMPONENT,
    INSTANTIATED_UNIT_ENTITY,
    INSTANTIATED_UNIT_CONFIGURATION,
    FORMAL_PART,
    ARRAY_TYPE_DEFINITION,
    CONSTRAINED_ARRAY_DEFINITION,
    UNCONSTRAINED_ARRAY_DEFINITION,
    INDEX_SUBTYPE_DEFINITION,
    COMPOSITE_TYPE_DEFINITION,
    RECORD_TYPE_DEFINITION,
    GENERATE_CASE_STATEMENT,
    FOR_GENERATE_STATEMENT,
    CASE_GENERATE_STATEMENT,
    GENERATION_SCHEME,
    GENERATION_SCHEME_FOR,
    GENERATION_SCHEME_IF,
    PARAMETER_SPECIFICATION,
    ATTRIBUTE_SPECIFICATION,
    ENTITY_SPECIFICATION,
    ENTITY_CLASS,
    ENTITY_NAME_LIST,
    ENTITY_DESIGNATOR,
    ENTITY_TAG,
    ELEMENT_DECLARATION,
    ALIAS_DECLARATION,
    ALIAS_DESIGNATOR,
    FILE_DECLARATION,
    FILE_OPEN_INFORMATION,
    SECONDARY_UNIT_DECLARATION,
    PHYSICAL_LITERAL,
    INTERFACE_CONSTANT_DECLARATION,
    PACKAGE_BODY_DECLARATIVE_ITEM,
    ITERATION_SCHEME,
    LOOP_STATEMENT,
    QUALIFIED_EXPRESSION,
    QUALIFIED_EXPRESSION_EXPRESSION,
    QUALIFIED_EXPRESSION_AGGREGATE,
    EXPRESSION_OR_NAME,
    SELECTED_WAVEFORMS,
    SELECTED_WAVEFORM,
    EXIT_STATEMENT,
    REPORT_STATEMENT,
    EOF,
    UNITS_DECL,
    CONFIGURATION_SPECIFICATION,
    INTERFACE_SIGNAL_DECLARATION,
    INTERFACE_FILE_DECLARATION,
    FILE_TYPE_DEFINITION,
    ACCESS_TYPE_DEFINITION,
    ALLOCATOR,
    NEXT_STATEMENT,
    CONCURRENT_PROCEDURE_CALL_STATEMENT,
    ENTITY_ASPECT,
    TARGET,
    BLOCK_DECLARATIVE_PART,
    BLOCK_STATEMENT_PART,
    BLOCK_HEADER,
    BLOCK_STATEMENT,
    LREC_SLICE_NAME,
    LREC_SELECTED_NAME,
    FULL_ASSOCIATION_ELEMENT,
    COMPONENT_CONFIGURATION,
    PROTECTED_TYPE_DEFINITION,
    PROTECTED_TYPE_DECLARATION,
    PROTECTED_TYPE_BODY,
    PROTECTED_TYPE_BODY_DECLARATIVE_ITEM,
    PROTECTED_TYPE_DECLARATION_ITEM,
    INTERFACE_PACKAGE_DECLARATION,
    PACKAGE_INSTANTIATION_DECLARATION,
    FULL_CHOICES,
    OPEN_CONSTRAINT,
    EXTERNAL_NAME,
    LREC_ATTRIBUTE_NAME,
    SUBPROGRAM_INSTANTIATION_DECLARATION,
    DISCONNECTION_SPECIFICATION,
    GROUP_TEMPLATE_DECLARATION,
    GROUP_DECLARATION,
    BINDING_INDICATION,
    COMPONENT_SPECIFICATION,
    CONTEXT_DECLARATION,
    GENERATION_SCHEME_CASE,
    DESIGNATOR,
    IDENTIFIER,
    IDENTIFIER_COLON,
    OPERATOR_SYMBOL,
    FORCE_MODE;

    private static final String SPECIAL_CHARACTER_REGEXP = "(?:[#&'()*+,-./:;<=>\\[\\]_|])";
    private static final String SPACE_CHARACTER_REGEXP = "(?:[ \\u00A0])";
    private static final String BASIC_GRAPHIC_CHARACTER_REGEXP = "(?:[A-Z0-9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u1e56]|(?:[#&'()*+,-./:;<=>\\[\\]_|])|(?:[ \\u00A0]))";
    private static final String OTHER_SPECIAL_CHARACTER_REGEXP = "(?:[!$%@?\\\\\\^`{}~\u00a1\u00a2\u00a3\u20ac\u00a5|\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac-\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u03bc\u00b6\u2022\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00d7\u00f7-])";
    private static final String GRAPHIC_CHARACTER_REGEXP = "(?:(?:[A-Z0-9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u1e56]|(?:[#&'()*+,-./:;<=>\\[\\]_|])|(?:[ \\u00A0]))|[a-z\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u2202\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u1e57\u00ff]|(?:[!$%@?\\\\\\^`{}~\u00a1\u00a2\u00a3\u20ac\u00a5|\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac-\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u03bc\u00b6\u2022\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00d7\u00f7-]))";
    private static final String INTEGER_LITERAL_REGEXP = "(?:[0-9][0-9_]*+)";
    private static final String DECIMAL_LITERAL_REGEXP = "(?:(?:[0-9][0-9_]*+)\\.(?:[0-9][0-9_]*+)|(?:[0-9][0-9_]*+))";
    private static final String CHARACTER_LITERAL_REGEXP = "(?:'(?:(?:[A-Z0-9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u1e56]|(?:[#&'()*+,-./:;<=>\\[\\]_|])|(?:[ \\u00A0]))|[a-z\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u2202\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u1e57\u00ff]|(?:[!$%@?\\\\\\^`{}~\u00a1\u00a2\u00a3\u20ac\u00a5|\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac-\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u03bc\u00b6\u2022\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00d7\u00f7-]))')";
    private static final String STRING_LITERAL_REGEXP = "(?:(\"(?:(?:[A-Z0-9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u1e56]|(?:[#&'()*+,-./:;<=>\\[\\]_|])|(?:[ \\u00A0]))|[a-z\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u2202\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u1e57\u00ff]|(?:[!$%@?\\\\\\^`{}~\u00a1\u00a2\u00a3\u20ac\u00a5|\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac-\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u03bc\u00b6\u2022\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00d7\u00f7-]))*+\")+)";
    private static final String BIT_STRING_LITERAL_REGEXP = "((?:[0-9][0-9_]*+))?(?:(?:B|O|X|D|b|o|x|d|UB|UO|UX|SB|SO|SX|ub|uo|ux|sb|so|sx|Ub|Uo|Ux|Sb|So|Sx|uB|uO|uX|sB|sO|sX)\"(?:[a-zA-Z0-9\\-](?:_?[a-zA-Z0-9\\-])*)?\")";
    private static final String BASED_LITERAL_REGEXP = "(?:(?:(?:[0-9][0-9_]*+)\\.(?:[0-9][0-9_]*+)|(?:[0-9][0-9_]*+))#(?:\\p{Alnum}(?:_?.?\\p{Alnum})*)#(E(\\+|-)?(?:(?:[0-9][0-9_]*+)\\.(?:[0-9][0-9_]*+)|(?:[0-9][0-9_]*+)))?)";

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        VhdlLexer.punctuators(b);
        VhdlLexer.keywords(b);
        VhdlLexer.literals(b);
        b.setRootRule(DESIGN_FILE);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        VhdlLexer.punctuator(b, VhdlPunctuator.ARROW, "=>");
        VhdlLexer.punctuator(b, VhdlPunctuator.ASSIG, ":=");
        VhdlLexer.punctuator(b, VhdlPunctuator.AT, "@");
        VhdlLexer.punctuator(b, VhdlPunctuator.BOX, "<>");
        VhdlLexer.punctuator(b, VhdlPunctuator.DOT, ".");
        VhdlLexer.punctuator(b, VhdlPunctuator.COLON, ":", b.nextNot("="));
        VhdlLexer.punctuator(b, VhdlPunctuator.COMMA, ",");
        VhdlLexer.punctuator(b, VhdlPunctuator.CONCA, "&");
        VhdlLexer.punctuator(b, VhdlPunctuator.COND, "??");
        VhdlLexer.punctuator(b, VhdlPunctuator.DIV, "/", b.nextNot("="));
        VhdlLexer.punctuator(b, VhdlPunctuator.DTAR, "**");
        VhdlLexer.punctuator(b, VhdlPunctuator.EQUAL, "=", b.nextNot(">"));
        VhdlLexer.punctuator(b, VhdlPunctuator.GE, ">=");
        VhdlLexer.punctuator(b, VhdlPunctuator.GT, ">", b.nextNot(b.firstOf("<", ">", "=")));
        VhdlLexer.punctuator(b, VhdlPunctuator.LE, "<=");
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHEQUAL, "?=", b.nextNot(">"));
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHGE, "?>=");
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHGT, "?>", b.nextNot("="));
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHLE, "?<=");
        VhdlLexer.punctuator(b, VhdlPunctuator.LBRACKET, "[");
        VhdlLexer.punctuator(b, VhdlPunctuator.LPAR, "(");
        VhdlLexer.punctuator(b, VhdlPunctuator.LT, "<", b.nextNot(b.firstOf("<", ">", "=")));
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHLT, "?<", b.nextNot(b.firstOf(">", "=")));
        VhdlLexer.punctuator(b, VhdlPunctuator.MINUS, "-");
        VhdlLexer.punctuator(b, VhdlPunctuator.NOTEQ, "/=");
        VhdlLexer.punctuator(b, VhdlPunctuator.MTCHNOTEQ, "?/=");
        VhdlLexer.punctuator(b, VhdlPunctuator.OR, "|");
        VhdlLexer.punctuator(b, VhdlPunctuator.PLUS, "+");
        VhdlLexer.punctuator(b, VhdlPunctuator.QUOTE, "'");
        VhdlLexer.punctuator(b, VhdlPunctuator.RBRACKET, "]");
        VhdlLexer.punctuator(b, VhdlPunctuator.RELATIVE, "^.");
        VhdlLexer.punctuator(b, VhdlPunctuator.RPAR, ")");
        VhdlLexer.punctuator(b, VhdlPunctuator.SEMICOLON, ";");
        VhdlLexer.punctuator(b, VhdlPunctuator.SL, "<<");
        VhdlLexer.punctuator(b, VhdlPunctuator.SR, ">>");
        VhdlLexer.punctuator(b, VhdlPunctuator.STAR, "*", b.nextNot("*"));
        VhdlLexer.punctuator(b, VhdlPunctuator.XOR, "^", b.nextNot("."));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule(LETTER_OR_DIGIT).is(VhdlLexer.javaIdentifierPart(b));
        for (VhdlKeyword tokenType : VhdlKeyword.values()) {
            b.rule(tokenType).is(b.regexp(tokenType.getRegexpString()), b.nextNot(LETTER_OR_DIGIT), SPACING);
        }
        Object[] keywords = VhdlKeyword.keywordRegexpValues();
        Arrays.sort(keywords);
        ArrayUtils.reverse(keywords);
        Object[] regexps = new Object[keywords.length];
        for (int i = 0; i < keywords.length; ++i) {
            regexps[i] = b.regexp((String)keywords[i]);
        }
        b.rule(KEYWORD).is(b.firstOf(regexps[0], regexps[1], ArrayUtils.subarray(regexps, 2, regexps.length)), b.nextNot(LETTER_OR_DIGIT));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is(value, SPACING);
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        b.rule(ruleKey).is(value, element, SPACING);
    }

    private static void literals(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(VhdlLexer.whitespace(b)), b.zeroOrMore(b.commentTrivia(VhdlLexer.comment(b)), b.skippedTrivia(VhdlLexer.whitespace(b))));
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput()));
        b.rule(VhdlTokenType.BASED_LITERAL).is(b.regexp(BASED_LITERAL_REGEXP), SPACING);
        b.rule(VhdlTokenType.INTEGER_LITERAL).is(b.regexp(INTEGER_LITERAL_REGEXP), SPACING);
        b.rule(VhdlTokenType.DECIMAL_LITERAL).is(b.regexp(DECIMAL_LITERAL_REGEXP), SPACING);
        b.rule(VhdlTokenType.CHARACTER_LITERAL).is(b.regexp("(?:'(?:(?:[A-Z0-9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u1e56]|(?:[#&'()*+,-./:;<=>\\[\\]_|])|(?:[ \\u00A0]))|[a-z\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u2202\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u1e57\u00ff]|(?:[!$%@?\\\\\\^`{}~\u00a1\u00a2\u00a3\u20ac\u00a5|\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac-\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u03bc\u00b6\u2022\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00d7\u00f7-]))')|('\"')"), SPACING);
        b.rule(VhdlTokenType.STRING_LITERAL).is(b.regexp(STRING_LITERAL_REGEXP), SPACING);
        b.rule(VhdlTokenType.BIT_STRING_LITERAL).is(b.regexp(BIT_STRING_LITERAL_REGEXP), SPACING);
        b.rule(VhdlTokenType.IDENTIFIER).is(b.nextNot(KEYWORD), VhdlLexer.javaIdentifier(b), b.nextNot("\""), SPACING);
    }

    private static Object whitespace(LexerlessGrammarBuilder b) {
        String protect = "(?i)`protect[^\\n\\r]*+";
        String protectBeginEnd = "(?i)`protect\\s+BEGIN[\\s\\S]*?`protect\\s+END";
        String protectBeginProtectedEndProtected = "(?i)`protect\\s+begin_protected[\\s\\S]*?`protect\\s+end_protected";
        String whitespace = "\\s";
        return b.regexp("(" + protectBeginProtectedEndProtected + "|" + protectBeginEnd + "|" + protect + "|" + whitespace + ")*+");
    }

    private static Object comment(LexerlessGrammarBuilder b) {
        return b.regexp("(--[^\\n\\r]*+)|(/\\*[\\s\\S]*?\\*/)");
    }

    private static Object javaIdentifier(LexerlessGrammarBuilder b) {
        return b.regexp("(\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+)|((\\\\[^\\\\]*\\\\)+)");
    }

    private static Object javaIdentifierPart(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierPart}");
    }
}

