/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.parser;

import com.google.common.collect.Lists;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.model.InternalSyntaxSpacing;
import com.lintyservices.sonar.plugins.vhdl.model.InternalSyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;

public class VhdlNodeBuilder
implements NodeBuilder {
    @Override
    public Object createNonTerminal(GrammarRuleKey ruleKey, Rule rule, List<Object> children, int startIndex, int endIndex) {
        for (Object child : children) {
            if (!(child instanceof VhdlInternalSyntaxToken)) continue;
            VhdlInternalSyntaxToken syntaxToken = (VhdlInternalSyntaxToken)child;
            syntaxToken.setGrammarRuleKey(ruleKey);
            return child;
        }
        return new InternalSyntaxSpacing(startIndex, endIndex);
    }

    @Override
    public Object createTerminal(Input input, int startIndex, int endIndex, List<Trivia> trivias, TokenType type) {
        boolean isEof = GenericTokenType.EOF.equals(type);
        LineColumnValue lineColumnValue = VhdlNodeBuilder.tokenPosition(input, startIndex, endIndex);
        return new VhdlInternalSyntaxToken(lineColumnValue.line, lineColumnValue.column, lineColumnValue.value, VhdlNodeBuilder.createTrivias(trivias), startIndex, endIndex, isEof);
    }

    private static List<SyntaxTrivia> createTrivias(List<Trivia> trivias) {
        ArrayList<SyntaxTrivia> result = Lists.newArrayList();
        for (Trivia trivia : trivias) {
            Token trivialToken = trivia.getToken();
            result.add(InternalSyntaxTrivia.create(trivialToken.getValue(), trivialToken.getLine(), trivialToken.getColumn()));
        }
        return result;
    }

    private static LineColumnValue tokenPosition(Input input, int startIndex, int endIndex) {
        int[] lineAndColumn = input.lineAndColumnAt(startIndex);
        String value = input.substring(startIndex, endIndex);
        return new LineColumnValue(lineAndColumn[0], lineAndColumn[1] - 1, value);
    }

    private record LineColumnValue(int line, int column, String value) {
    }
}

