/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.visitors;

import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSubscriptionVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.VhdlLexer;
import java.io.File;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;

public class VhdlCpdVisitor
extends VhdlSubscriptionVisitor {
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private InputFile inputFile;
    private NewCpdTokens cpdTokens;

    @Override
    public Set<VhdlTree.Kind> nodesToVisit() {
        return Set.of(VhdlTree.Kind.TOKEN);
    }

    public VhdlCpdVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public void visitFile(VhdlTree tree) {
        File file = this.context().file();
        this.inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(file));
        this.cpdTokens = this.sensorContext.newCpdTokens().onFile(this.inputFile);
    }

    @Override
    public void leaveFile(VhdlTree scriptTree) {
        this.cpdTokens.save();
    }

    @Override
    public void visitNode(VhdlTree tree) {
        VhdlInternalSyntaxToken token = (VhdlInternalSyntaxToken)tree;
        if (token.getGrammarRuleKey() == VhdlLexer.EOF) {
            return;
        }
        TextRange range = this.inputFile.newRange(token.line(), token.column(), token.endLine(), token.endColumn());
        this.cpdTokens.addToken(range, token.text());
    }
}

