/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.visitors;

import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.SyntaxTrivia;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.lexer.VhdlKeyword;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;

public class VhdlSyntaxHighlighterVisitor
extends DoubleDispatchVisitor {
    private static final Set<String> VHDL_KEYWORDS = Arrays.stream(VhdlKeyword.values()).map(VhdlKeyword::getValue).collect(Collectors.toSet());
    private final SensorContext sensorContext;
    private final FileSystem fileSystem;
    private NewHighlighting highlighting;

    public VhdlSyntaxHighlighterVisitor(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        this.highlighting = this.sensorContext.newHighlighting().onFile(this.fileSystem.inputFile(this.fileSystem.predicates().is(this.context().file())));
        super.visitDesignFile(tree);
        this.highlighting.save();
    }

    @Override
    public void visitInternalSyntaxToken(VhdlInternalSyntaxToken token) {
        if (!token.isSynthesized()) {
            this.highlight(token, TypeOfText.COMMENT);
            for (SyntaxTrivia trivia : token.trivias()) {
                this.highlight(trivia, TypeOfText.COMMENT);
            }
        } else if (VHDL_KEYWORDS.contains(token.text().toLowerCase())) {
            this.highlight(token, TypeOfText.KEYWORD_LIGHT);
            for (SyntaxTrivia trivia : token.trivias()) {
                this.highlight(trivia, TypeOfText.STRING);
            }
        } else {
            for (SyntaxTrivia trivia : token.trivias()) {
                this.highlight(trivia, TypeOfText.STRING);
            }
        }
        super.visitInternalSyntaxToken(token);
    }

    protected void highlight(VhdlSyntaxToken token, TypeOfText type) {
        this.highlighting.highlight(token.line(), token.column(), token.endLine(), token.endColumn(), type);
    }
}

