/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.utils;

import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

public class FileUtils {
    public static final String CANNOT_GET_CANONICAL_PATH = "Cannot get canonical path for ";

    private FileUtils() {
    }

    public static boolean contains(Set<File> files, File file) {
        try {
            return files.stream().map(f -> {
                try {
                    return f.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new LintyException(CANNOT_GET_CANONICAL_PATH + String.valueOf(f.getAbsoluteFile()), e);
                }
            }).collect(Collectors.toSet()).contains(file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new LintyException(CANNOT_GET_CANONICAL_PATH + String.valueOf(file.getAbsoluteFile()), e);
        }
    }

    public static boolean equals(File file1, File file2) {
        String path2;
        String path1;
        try {
            path1 = file1.getCanonicalPath();
        }
        catch (IOException e) {
            throw new LintyException(CANNOT_GET_CANONICAL_PATH + String.valueOf(file1.getAbsoluteFile()), e);
        }
        try {
            path2 = file2.getCanonicalPath();
        }
        catch (IOException e) {
            throw new LintyException(CANNOT_GET_CANONICAL_PATH + String.valueOf(file2.getAbsoluteFile()), e);
        }
        return path1.equals(path2);
    }

    public static String markdownPath(File file, String baseDir) {
        try {
            Object path = file.getCanonicalPath().substring(baseDir.length());
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return path;
        }
        catch (IOException e) {
            throw new LintyException(CANNOT_GET_CANONICAL_PATH + String.valueOf(file.getAbsoluteFile()), e);
        }
    }

    public static String sanitizedPath(String path) {
        if (path.startsWith("/usr/src")) {
            return path.replace("/usr/src/", "./");
        }
        return path;
    }
}

