/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.utils;

import java.util.regex.Pattern;

public class RegexUtils {
    private static final String EMAIL_ADDRESS_REGEX = "[a-zA-Z0-9_!#$%&\u2019*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+";
    private static final String EMAIL_ADDRESS_REGEX_PLACEHOLDER = "{EMAIL}";
    private static final String URL_REGEX = "https?:\\/\\/(?:www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b(?:[-a-zA-Z0-9()@:%_\\+.~#?&\\/=]*)";
    private static final String URL_REGEX_PLACEHOLDER = "{URL}";
    public static final String PLACEHOLDERS_MESSAGE = "The following placeholders can be used to ease the writing of the regular expression: {EMAIL} and {URL}. They will be replaced with proper regular expressions at runtime.";

    private RegexUtils() {
    }

    public static Pattern processPattern(String regex) {
        return Pattern.compile(RegexUtils.processRegex(regex), 32);
    }

    private static String processRegex(String regex) {
        return regex.replace(EMAIL_ADDRESS_REGEX_PLACEHOLDER, EMAIL_ADDRESS_REGEX).replace(URL_REGEX_PLACEHOLDER, URL_REGEX);
    }
}

