/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysScope;
import com.lintyservices.yosys.objects.YosysScopes;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class YosysCell
implements YosysObject,
YosysModuleInterface,
YosysLocationInterface {
    private final String name;
    private final String type;
    @Nullable
    private final YosysScopes scopes;
    private final YosysModule module;
    @Nullable
    private final YosysLocation location;

    public YosysCell(Map<String, Object> json, String yosysBuildDir) {
        this.name = (String)json.get("name");
        this.type = (String)json.get("type");
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        this.scopes = json.get("scope") != null ? new YosysScopes(((List)json.get("scope")).stream().map(scope -> new YosysScope((Map<String, Object>)scope, yosysBuildDir)).collect(Collectors.toList())) : null;
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public YosysScopes scopes() {
        return this.scopes;
    }

    public String beautifulType() {
        return this.type.startsWith("$") ? this.type.substring(1).toUpperCase() : this.type.toUpperCase();
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysCell)) {
            return false;
        }
        YosysCell c = (YosysCell)o;
        if (c.location() != null && this.location != null) {
            return c.location().equals(this.location());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.location != null) {
            result = 31 * result + this.location.hashCode();
        }
        return result;
    }
}

