/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class YosysClockManagementModule
implements YosysObject {
    private final YosysModule topModule;
    private final boolean instantiatedInTopModule;
    private final boolean isTopModule;
    private final int nestedScopeCount;
    private final int logicCount;
    @Nullable
    private String instanceName;
    @Nullable
    private YosysLocation instanceLocation;
    @Nullable
    private String moduleName;
    @Nullable
    private YosysLocation moduleLocation;

    public YosysClockManagementModule(Map<String, Object> json, String yosysBuildDir) {
        this.topModule = new YosysModule((Map)json.get("top_module"), yosysBuildDir);
        this.isTopModule = (Boolean)json.get("is_top_module");
        this.nestedScopeCount = (Integer)json.get("nested_scope_count");
        this.logicCount = (Integer)json.get("logic_count");
        if (!this.isTopModule) {
            this.instanceName = (String)((Map)json.get("instantiation")).get("name");
            this.instanceLocation = new YosysLocation((Map)((Map)json.get("instantiation")).get("location"), yosysBuildDir);
            this.moduleName = (String)((Map)json.get("module")).get("name");
            this.moduleLocation = new YosysLocation((Map)((Map)json.get("module")).get("location"), yosysBuildDir);
            this.instantiatedInTopModule = (Boolean)json.get("instantiated_in_top_module");
        } else {
            this.instantiatedInTopModule = false;
        }
    }

    public YosysModule topModule() {
        return this.topModule;
    }

    @Nullable
    public String instanceName() {
        return this.instanceName;
    }

    @Nullable
    public YosysLocation instanceLocation() {
        return this.instanceLocation;
    }

    @Nullable
    public String moduleName() {
        return this.moduleName;
    }

    @Nullable
    public YosysLocation moduleLocation() {
        return this.moduleLocation;
    }

    public boolean instantiatedInTopModule() {
        return this.instantiatedInTopModule;
    }

    public boolean isTopModule() {
        return this.isTopModule;
    }

    public int nestedScopeCount() {
        return this.nestedScopeCount;
    }

    public int logicCount() {
        return this.logicCount;
    }

    public boolean isCmm(Set<File> filesToAnalyze) {
        return this.instanceLocation != null && this.instanceName != null && this.nestedScopeCount <= 1 && FileUtils.contains(filesToAnalyze, this.moduleLocation.file());
    }
}

