/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.interfaces.YosysResetClockDomainOrigin;
import com.lintyservices.yosys.objects.ResetClockDomainOriginType;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsConstant;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsFlipFlop;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsPort;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class YosysClockOrResetDomain
implements YosysObject,
YosysLocationInterface {
    private final String name;
    @Nullable
    private final YosysLocation location;
    private final List<YosysResetClockDomainOrigin> origins;
    @Nullable
    private final Integer flipFlops;
    @Nullable
    private final Integer modules;
    @Nullable
    private final Double percentageFlipFlops;
    private final List<YosysFlipFlop> usedInFFs;

    protected YosysClockOrResetDomain(Map<String, Object> json, String yosysBuildDir) {
        this.name = (String)json.get("name");
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        this.origins = new ArrayList<YosysResetClockDomainOrigin>();
        for (Map origin : (List)json.get("origins")) {
            String type = (String)origin.get("type");
            if (ResetClockDomainOriginType.FLIP_FLOP_OUTPUT == ResetClockDomainOriginType.valueOf(type)) {
                this.origins.add(new YosysResetClockDomainOriginAsFlipFlop(origin, yosysBuildDir));
                continue;
            }
            if (ResetClockDomainOriginType.TOP_LEVEL_PORT == ResetClockDomainOriginType.valueOf(type) || ResetClockDomainOriginType.BLACKBOX_PORT == ResetClockDomainOriginType.valueOf(type)) {
                this.origins.add(new YosysResetClockDomainOriginAsPort(origin, yosysBuildDir));
                continue;
            }
            if (ResetClockDomainOriginType.CONSTANT != ResetClockDomainOriginType.valueOf(type)) continue;
            this.origins.add(new YosysResetClockDomainOriginAsConstant(origin));
        }
        this.flipFlops = (Integer)json.get("number_of_flip_flops");
        this.modules = (Integer)json.get("number_of_modules");
        Object percentage = json.get("percentage_of_flip_flops");
        this.percentageFlipFlops = percentage == null ? null : Double.valueOf(percentage instanceof Integer ? (double)((Integer)percentage).intValue() : ((BigDecimal)percentage).doubleValue());
        this.usedInFFs = json.get("used_in_ffs") != null ? ((List)json.get("used_in_ffs")).stream().map(ff -> new YosysFlipFlop((Map)ff, yosysBuildDir)).toList() : new ArrayList<YosysFlipFlop>();
    }

    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public List<YosysResetClockDomainOrigin> origins() {
        return this.origins;
    }

    @Nullable
    public Integer flipFlops() {
        return this.flipFlops;
    }

    @Nullable
    public Double percentageFlipFlops() {
        return this.percentageFlipFlops;
    }

    @Nullable
    public Integer modules() {
        return this.modules;
    }

    public List<YosysFlipFlop> usedInFFs() {
        return this.usedInFFs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysClockOrResetDomain)) {
            return false;
        }
        YosysClockOrResetDomain d = (YosysClockOrResetDomain)o;
        if (d.location() != null && this.location != null) {
            return d.location().equals(this.location());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.location != null) {
            result = 31 * result + this.location.hashCode();
        }
        return result;
    }
}

