/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysObject;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysLocation
implements YosysObject {
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;
    private final File file;
    private final String relativePath;

    public YosysLocation(Map<String, Object> json, String yosysBuildDir) {
        this.file = "".equals(yosysBuildDir) ? new File((String)json.get("file_path")) : new File(yosysBuildDir + File.separator + String.valueOf(json.get("file_path")));
        this.relativePath = (String)json.get("file_path");
        this.beginLine = (Integer)json.get("begin_line");
        this.beginColumn = (Integer)json.get("begin_column");
        this.endLine = (Integer)json.get("end_line");
        this.endColumn = (Integer)json.get("end_column");
    }

    public YosysLocation(String filePath, int beginLine, int beginColumn, int endLine, int endColumn, String yosysBuildDir) {
        this.file = "".equals(yosysBuildDir) ? new File(filePath) : new File(yosysBuildDir + File.separator + filePath);
        this.relativePath = filePath;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public YosysLocation(File file, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.file = file;
        this.relativePath = file.getAbsolutePath();
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public int beginLine() {
        return this.beginLine;
    }

    public int beginColumn() {
        return this.beginColumn;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endColumn() {
        return this.endColumn;
    }

    public File file() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysLocation)) {
            return false;
        }
        YosysLocation l = (YosysLocation)o;
        return l.beginLine() == this.beginLine() && l.beginColumn() == this.beginColumn() && l.endLine() == this.endLine() && l.endColumn() == this.endColumn() && l.file().equals(this.file());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result * this.beginLine;
        result = 31 * result * this.beginColumn;
        result = 31 * result * this.endLine;
        result = 31 * result * this.endColumn;
        result = 31 * result * this.file.hashCode();
        return result;
    }

    public String text() {
        return this.file.getName() + " (L" + this.beginLine + ":L" + this.endLine + ")";
    }

    public String markdown() {
        return this.markdown(null);
    }

    public String markdown(@Nullable String text) {
        String name = this.file.getName();
        Object path = this.relativePath.startsWith(".") ? this.relativePath.substring(1) : "/" + this.relativePath;
        String display = text != null ? text : name + "#" + this.beginLine;
        String link = String.format("%s#%s", path, this.beginLine);
        return String.format("<linty-anchor href=\"/%s\">%s</linty-anchor>", link, display);
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String toString() {
        return String.format("File: %s%nBegin line: %d%nBegin column: %d%nEnd line: %d%nEnd column: %s", this.file.getAbsolutePath(), this.beginLine, this.beginColumn, this.endLine, this.endColumn);
    }
}

