/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysModule
implements YosysObject,
YosysLocationInterface {
    private final String name;
    private final String fullName;
    @Nullable
    private final Boolean blackbox;
    @Nullable
    private final String library;
    @Nullable
    private final YosysLocation location;
    @Nullable
    private final YosysLocation architectureLocation;

    public YosysModule(Map<String, Object> json, String yosysBuildDir) {
        this.fullName = (String)json.get("full_name");
        this.name = (String)json.get("name");
        this.library = (String)json.get("library");
        this.blackbox = json.get("blackbox") != null ? Boolean.valueOf((Boolean)json.get("blackbox")) : null;
        Map yosysLocation = (Map)json.get("location");
        this.location = yosysLocation != null && !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        Map yosysArchitectureLocation = (Map)json.get("architecture_location");
        this.architectureLocation = yosysArchitectureLocation != null && !yosysArchitectureLocation.isEmpty() ? new YosysLocation(yosysArchitectureLocation, yosysBuildDir) : null;
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.fullName;
    }

    public boolean blackbox() {
        return this.blackbox;
    }

    @Nullable
    public String library() {
        return this.library;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    @Nullable
    public YosysLocation architectureLocation() {
        return this.architectureLocation;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysModule)) {
            return false;
        }
        YosysModule m = (YosysModule)o;
        boolean bl = result = m.name().equals(this.name()) && m.library.equals(this.library);
        if (m.location() != null) {
            result = result && m.location().equals(this.location());
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        if (this.library != null) {
            result = 31 * result + this.library.hashCode();
        }
        if (this.location != null) {
            result = 31 * result + this.location.hashCode();
        }
        return result;
    }

    public String toString() {
        return String.format("Name: %s%nLibrary: %s%nLocation: %s%nArchitecture Location: %s%n", this.name, this.library, this.location != null ? this.location.toString() : "null", this.architectureLocation != null ? this.architectureLocation.toString() : "null");
    }
}

