/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysCell;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysModuleInstantiationParameter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class YosysModuleInstantiation
implements YosysObject,
YosysModuleInterface {
    private final YosysModule module;
    private final Set<YosysModuleInstantiationParameter> parameters;
    @Nullable
    private final YosysCell cell;
    private final Set<YosysModuleInstantiation> children;

    public YosysModuleInstantiation(Map<String, Object> json, String yosysBuildDir) {
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        this.cell = !((Map)json.get("instantiation")).isEmpty() ? new YosysCell((Map)json.get("instantiation"), yosysBuildDir) : null;
        this.parameters = new HashSet<YosysModuleInstantiationParameter>();
        for (Map p : (List)json.get("parameters")) {
            this.parameters.add(new YosysModuleInstantiationParameter(p));
        }
        HashSet<YosysModuleInstantiation> rawChildren = new HashSet<YosysModuleInstantiation>();
        for (Map p : (List)json.get("instantiates")) {
            rawChildren.add(new YosysModuleInstantiation(p, yosysBuildDir));
        }
        this.children = rawChildren.stream().filter(c -> !c.module.name().contains("$") && !c.cell.name().contains("$")).collect(Collectors.toSet());
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    public Set<YosysModuleInstantiationParameter> parameters() {
        return this.parameters;
    }

    public Set<String> notDefaultValueParameters() {
        HashSet<String> parameters = new HashSet<String>();
        Pattern pattern = Pattern.compile("(?s)(?=\\()(?:(?=.*?\\((?!.*?\\1)(.*\\)(?!.*\\2).*))(?=.*?\\)(?!.*?\\2)(.*)).)+?.*?(?=\\1)[^(]*(?=\\2$)", 32);
        for (MatchResult match : YosysModuleInstantiation.allMatches(pattern, this.module.fullName())) {
            String[] splitGroup;
            String group = match.group(0).trim();
            group = group.substring(1, group.length() - 1);
            for (String split : splitGroup = group.split(",")) {
                if (!split.contains("=")) continue;
                parameters.add(split.split("=")[0].toLowerCase());
            }
        }
        return parameters;
    }

    @Nullable
    public YosysCell cell() {
        return this.cell;
    }

    public Set<YosysModuleInstantiation> children() {
        return this.children;
    }

    public int numberOfInstantiatedModules() {
        return 1 + this.numberOfInstantiatedModules(this);
    }

    private int numberOfInstantiatedModules(YosysModuleInstantiation module) {
        int count = module.children.size();
        for (YosysModuleInstantiation child : module.children()) {
            count += this.numberOfInstantiatedModules(child);
        }
        return count;
    }

    private static Iterable<MatchResult> allMatches(final Pattern p, final CharSequence input) {
        return () -> new Iterator<MatchResult>(){
            final Matcher matcher;
            MatchResult pending;
            {
                this.matcher = p.matcher(input);
            }

            @Override
            public boolean hasNext() {
                if (this.pending == null && this.matcher.find()) {
                    this.pending = this.matcher.toMatchResult();
                }
                return this.pending != null;
            }

            @Override
            public MatchResult next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                MatchResult next = this.pending;
                this.pending = null;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

