/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.helpers.port.PortBitType;
import com.lintyservices.yosys.helpers.port.PortDirection;
import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.BitMissingRegistrationLevels;
import com.lintyservices.yosys.objects.YosysCell;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysPortBit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class YosysPort
implements YosysObject,
YosysModuleInterface,
YosysLocationInterface {
    private final String name;
    private final String shortName;
    private final PortDirection direction;
    private final YosysModule module;
    private final List<Integer> bitOffsets;
    private final int startOffset;
    private final int endOffset;
    private final int width;
    private final boolean upto;
    private final Map<Integer, Set<Integer>> missingRegistrationBits;
    @Nullable
    private final YosysLocation location;
    private final List<YosysPortBit> bits;

    public YosysPort(Map<String, Object> json, String yosysBuildDir) {
        this.name = (String)json.get("name");
        this.shortName = this.name.split("\\[")[0];
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        this.bitOffsets = (List)json.get("bit_offsets");
        this.startOffset = (Integer)json.get("start_offset");
        this.endOffset = (Integer)json.get("end_offset");
        this.width = this.endOffset - this.startOffset + 1;
        this.upto = (Boolean)json.get("upto");
        this.missingRegistrationBits = new HashMap<Integer, Set<Integer>>();
        if (json.get("bit_missing_registration_levels") != null) {
            ((List)json.get("bit_missing_registration_levels")).stream().map(o -> new BitMissingRegistrationLevels((Integer)o.get("bit_offset"), (Integer)o.get("levels"))).forEach(r -> {
                if (this.missingRegistrationBits.containsKey(r.levels())) {
                    this.missingRegistrationBits.get(r.levels()).add(r.bitOffset());
                } else {
                    HashSet<Integer> set = new HashSet<Integer>();
                    set.add(r.bitOffset());
                    this.missingRegistrationBits.put(r.levels(), set);
                }
            });
        }
        this.bits = new ArrayList<YosysPortBit>();
        List bitTypes = new ArrayList();
        if (json.get("bit_types") != null) {
            bitTypes = (List)json.get("bit_types");
        }
        List bitMissingRegistrationLevels = new ArrayList();
        if (json.get("bit_missing_registration_levels") != null) {
            bitMissingRegistrationLevels = (List)json.get("bit_missing_registration_levels");
        }
        List cells = new ArrayList();
        if (json.get("connected_cells") != null) {
            cells = (List)json.get("connected_cells");
        }
        HashSet<Integer> allBitOffsets = new HashSet<Integer>();
        allBitOffsets.addAll(this.bitOffsets);
        allBitOffsets.addAll(bitTypes.stream().map(o -> (Integer)o.get("bit_offset")).collect(Collectors.toSet()));
        allBitOffsets.addAll(cells.stream().map(o -> (Integer)o.get("bit_offset")).collect(Collectors.toSet()));
        Iterator iterator2 = allBitOffsets.iterator();
        while (iterator2.hasNext()) {
            Object bitType2;
            int bitOffset = (Integer)iterator2.next();
            HashSet<PortBitType> types = new HashSet<PortBitType>();
            for (Object bitType2 : bitTypes) {
                if ((Integer)bitType2.get("bit_offset") != bitOffset) continue;
                if (((Boolean)((Map)bitType2.get("type")).get("enable")).booleanValue()) {
                    types.add(PortBitType.ENABLE);
                }
                if (!((Boolean)((Map)bitType2.get("type")).get("reset")).booleanValue()) break;
                types.add(PortBitType.RESET);
                break;
            }
            Set<YosysCell> connectedCells = new HashSet<YosysCell>();
            bitType2 = cells.iterator();
            while (bitType2.hasNext()) {
                Map c = (Map)bitType2.next();
                if ((Integer)c.get("bit_offset") != bitOffset) continue;
                connectedCells = ((List)c.get("cells")).stream().map(o -> new YosysCell((Map<String, Object>)o, yosysBuildDir)).collect(Collectors.toSet());
                break;
            }
            int missingRegistrationLevels = 0;
            for (Map c : bitMissingRegistrationLevels) {
                if ((Integer)c.get("bit_offset") != bitOffset) continue;
                missingRegistrationLevels = (Integer)c.get("levels");
                break;
            }
            this.bits.add(new YosysPortBit(bitOffset, types, connectedCells, missingRegistrationLevels));
        }
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        boolean in = (Boolean)json.get("in");
        boolean out = (Boolean)json.get("out");
        if (in && out) {
            this.direction = PortDirection.INOUT;
        } else if (in) {
            this.direction = PortDirection.IN;
        } else if (out) {
            this.direction = PortDirection.OUT;
        } else {
            throw new LintyException("Unknown port direction for " + this.name + " port in " + this.module.name() + " module.");
        }
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public PortDirection direction() {
        return this.direction;
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public List<Integer> bitOffsets() {
        return this.bitOffsets;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public int width() {
        return this.width;
    }

    public boolean upto() {
        return this.upto;
    }

    public String range() {
        if (this.width == 1) {
            return "";
        }
        if (this.upto) {
            return this.startOffset + ":" + this.endOffset;
        }
        return this.endOffset + ":" + this.startOffset;
    }

    public Set<YosysCell> connectedCells() {
        return this.bits.stream().map(YosysPortBit::connectedCells).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean isMultiDimensions() {
        return this.name.contains("[");
    }

    @Nullable
    public String dimensions() {
        if (this.isMultiDimensions()) {
            return this.name.split("(?=\\[)", 2)[1];
        }
        return null;
    }

    public List<YosysPortBit> bits() {
        return this.bits;
    }

    public Map<Integer, Set<Integer>> missingRegistrationBits() {
        return this.missingRegistrationBits;
    }
}

