/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysModuleInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysResetUsage
implements YosysObject,
YosysModuleInterface,
YosysLocationInterface {
    private final String name;
    private final String shortName;
    private final ResetPolarity polarity;
    private final ResetType type;
    private final YosysModule module;
    private final boolean multipleSignalsInvolved;
    private final List<YosysSignal> relatedPublicWires;
    private final List<YosysSignal> sourceSignals;
    @Nullable
    private final YosysLocation location;

    public YosysResetUsage(Map<String, Object> json, String yosysBuildDir) {
        this.name = ((String)json.get("name")).replace("[", ".").replace("]", "");
        String[] splitName = ((String)json.get("name")).split("\\[");
        this.shortName = splitName.length == 2 ? splitName[1].replace("]", "") : splitName[0];
        this.multipleSignalsInvolved = this.name.contains("$");
        this.polarity = this.multipleSignalsInvolved ? ResetPolarity.UNDEFINED : ((Boolean)json.get("polarity") != false ? ResetPolarity.ACTIVE_HIGH : ResetPolarity.ACTIVE_LOW);
        this.type = (Boolean)json.get("synchronous") != false ? ResetType.SYNCHRONOUS : ResetType.ASYNCHRONOUS;
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
        this.relatedPublicWires = ((List)json.get("public_wires")).stream().map(o -> new YosysSignal((Map<String, Object>)o, yosysBuildDir)).toList();
        this.sourceSignals = ((List)json.get("source_signals")).stream().map(s -> new YosysSignal((Map<String, Object>)s, yosysBuildDir)).toList();
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public ResetPolarity polarity() {
        return this.polarity;
    }

    public ResetType type() {
        return this.type;
    }

    @Override
    public YosysModule module() {
        return this.module;
    }

    @Override
    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public boolean multipleSignalsInvolved() {
        return this.multipleSignalsInvolved;
    }

    public List<YosysSignal> relatedPublicWires() {
        return this.relatedPublicWires;
    }

    public boolean belongsToFile(File file) {
        return this.location != null && FileUtils.equals(this.location.file(), file);
    }

    public List<YosysSignal> sourceSignals() {
        return this.sourceSignals;
    }
}

