/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysScope;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class YosysScopes
implements YosysObject {
    private List<YosysScope> scopes;

    public YosysScopes(List<YosysScope> scopes) {
        this.scopes = scopes;
        Collections.reverse(this.scopes);
    }

    public List<YosysScope> scopes() {
        return this.scopes;
    }

    public String instantiationPathAsMarkdown() {
        return this.scopes.stream().map(s -> {
            StringBuilder text = new StringBuilder();
            if (s.instance() == null) {
                text.append("TOP");
            } else {
                text.append(s.instance().location().markdown(s.instance().name()));
            }
            text.append(" (").append(s.module().moduleLocation().markdown(s.module().name())).append(")");
            return text;
        }).collect(Collectors.joining(" > "));
    }

    public String id() {
        return this.scopes.stream().map(s -> s.instance() != null ? s.instance().name() : "top").collect(Collectors.joining(" "));
    }

    public YosysLocation instanceLocation() {
        int size = this.scopes.size();
        if (this.scopes.get(size - 1).instance() != null) {
            return this.scopes.get(size - 1).instance().location();
        }
        return this.scopes.get(size - 1).module().moduleLocation();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysScopes)) {
            return false;
        }
        YosysScopes s = (YosysScopes)o;
        return s.id().equals(this.id());
    }

    public int hashCode() {
        return 31 + this.id().hashCode();
    }
}

