/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysSignal
implements YosysObject {
    private final String name;
    private final String shortName;
    private final YosysModule module;
    @Nullable
    private final YosysLocation location;

    public YosysSignal(Map<String, Object> json, String yosysBuildDir) {
        String sname = this.name = (String)json.get("name");
        if (this.name.contains(".")) {
            String[] splitName = this.name.split("\\.");
            sname = splitName[splitName.length - 1];
        }
        this.shortName = sname.split("\\[")[0];
        this.module = new YosysModule((Map)json.get("module"), yosysBuildDir);
        Map yosysLocation = (Map)json.get("location");
        this.location = !yosysLocation.isEmpty() ? new YosysLocation(yosysLocation, yosysBuildDir) : null;
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public YosysModule module() {
        return this.module;
    }

    @Nullable
    public YosysLocation location() {
        return this.location;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        if (!(o instanceof YosysSignal)) {
            return false;
        }
        YosysSignal s = (YosysSignal)o;
        boolean bl = result = s.name().equals(this.name()) && s.module().equals(this.module());
        if (s.location() != null) {
            result = result && s.location().equals(this.location());
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        if (this.location != null) {
            result = 31 * result + this.location.hashCode();
        }
        result = 31 * result + this.module.hashCode();
        return result;
    }
}

