/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.yosys.objects;

import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.helpers.synthesized.SynthesizedObjectType;
import com.lintyservices.yosys.interfaces.YosysLocationInterface;
import com.lintyservices.yosys.interfaces.YosysObject;
import com.lintyservices.yosys.objects.YosysLocation;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;

public class YosysSynthesizedObject
implements YosysObject,
YosysLocationInterface {
    private final String name;
    private final String shortName;
    private final SynthesizedObjectType type;
    @Nullable
    private final YosysLocation location;

    public YosysSynthesizedObject(Map<String, Object> json, String yosysBuildDir) {
        this.name = (String)json.get("name");
        this.type = SynthesizedObjectType.get((String)json.get("type"));
        this.shortName = this.type == SynthesizedObjectType.ENTITY ? this.name.split("_default")[0].split("\\(")[0] : this.name;
        this.location = new YosysLocation((String)json.get("file_path"), (Integer)json.get("begin_line"), (Integer)json.get("begin_column"), (Integer)json.get("end_line"), (Integer)json.get("end_column"), yosysBuildDir);
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public SynthesizedObjectType type() {
        return this.type;
    }

    @Override
    public YosysLocation location() {
        return this.location;
    }

    public boolean belongsToFile(File file) {
        return this.location != null && FileUtils.equals(this.location.file(), file);
    }
}

