/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.profiles;

import com.optimaize.langdetect.frma.LangProfileReader;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.OldLangProfileConverter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LanguageProfileReader {
    private static final LangProfileReader internalReader = new LangProfileReader();
    private static final String PROFILES_DIR = "languages";

    public LanguageProfile read(File profileFile) throws IOException {
        return OldLangProfileConverter.convert(internalReader.read(profileFile));
    }

    public LanguageProfile read(InputStream inputStream2) throws IOException {
        return OldLangProfileConverter.convert(internalReader.read(inputStream2));
    }

    public List<LanguageProfile> read(ClassLoader classLoader, String profileDirectory, Collection<String> profileFileNames) throws IOException {
        ArrayList<LanguageProfile> loaded = new ArrayList<LanguageProfile>(profileFileNames.size());
        for (String profileFileName : profileFileNames) {
            String path = this.makePathForClassLoader(profileDirectory, profileFileName);
            InputStream in = classLoader.getResourceAsStream(path);
            Throwable throwable = null;
            try {
                if (in == null) {
                    throw new IOException("No language file available named " + profileFileName + " at " + path + "!");
                }
                loaded.add(this.read(in));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                in.close();
            }
        }
        return loaded;
    }

    private String makePathForClassLoader(String profileDirectory, String fileName) {
        return profileDirectory + '/' + fileName;
    }

    public List<LanguageProfile> read(String profileDirectory, Collection<String> profileFileNames) throws IOException {
        return this.read(LanguageProfileReader.class.getClassLoader(), profileDirectory, profileFileNames);
    }

    public List<LanguageProfile> read(Collection<String> profileFileNames) throws IOException {
        return this.read(LanguageProfileReader.class.getClassLoader(), PROFILES_DIR, profileFileNames);
    }

    @NotNull
    public LanguageProfile readBuiltIn(@NotNull LdLocale locale) throws IOException {
        String filename = this.makeProfileFileName(locale);
        String path = this.makePathForClassLoader(PROFILES_DIR, filename);
        try (InputStream in = LanguageProfileReader.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                throw new IOException("No language file available named " + filename + " at " + path + "!");
            }
            LanguageProfile languageProfile = this.read(in);
            return languageProfile;
        }
    }

    @NotNull
    private String makeProfileFileName(@NotNull LdLocale locale) {
        return locale.toString();
    }

    @NotNull
    public List<LanguageProfile> readBuiltIn(@NotNull Collection<LdLocale> languages) throws IOException {
        ArrayList<String> profileNames = new ArrayList<String>();
        for (LdLocale locale : languages) {
            profileNames.add(this.makeProfileFileName(locale));
        }
        return this.read(LanguageProfileReader.class.getClassLoader(), PROFILES_DIR, profileNames);
    }

    public List<LanguageProfile> readAll() throws IOException {
        return this.readAllBuiltIn();
    }

    public List<LanguageProfile> readAllBuiltIn() throws IOException {
        ArrayList<LanguageProfile> loaded = new ArrayList<LanguageProfile>();
        for (LdLocale locale : BuiltInLanguages.getLanguages()) {
            loaded.add(this.readBuiltIn(locale));
        }
        return loaded;
    }

    public List<LanguageProfile> readAll(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("No such folder: " + path);
        }
        if (!path.canRead()) {
            throw new IOException("Folder not readable: " + path);
        }
        File[] listFiles = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return LanguageProfileReader.this.looksLikeLanguageProfileFile(pathname);
            }
        });
        if (listFiles == null) {
            throw new IOException("Failed reading from folder: " + path);
        }
        ArrayList<LanguageProfile> profiles = new ArrayList<LanguageProfile>(listFiles.length);
        for (File file : listFiles) {
            if (!this.looksLikeLanguageProfileFile(file)) continue;
            profiles.add(this.read(file));
        }
        return profiles;
    }

    private boolean looksLikeLanguageProfileFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.looksLikeLanguageProfileName(file.getName());
    }

    private boolean looksLikeLanguageProfileName(String fileName) {
        if (fileName.contains(".")) {
            return false;
        }
        try {
            LdLocale.fromString(fileName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

