from datetime import datetime

html_context = {
    'project_name': '{{project_name}}',
    'project_version': '{{project_version}}',
    'generation_time': datetime.now().strftime("%B %d, %Y at %H:%M:%S"),
    'show_sphinx': False
}

project = '{{project_name}}<br><br>{{project_version}}'
author = 'Linty'

source_suffix = {
    '.rst': 'restructuredtext',
    '.md': 'markdown',
{{hdl_suffixes}}
}

extensions = ['myst_parser', 'sphinx_rtd_theme']

html_title = "{{project_name}}"
html_theme = "sphinx_rtd_theme"
html_static_path = ['_static']
html_css_files = ['style/linty.css']
templates_path = ['_templates']
html_extra_path = ['html']
