/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.fpgametrics.sensor;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.lintyservices.sonar.plugins.fpgametrics.sensor.MetricsImporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class MeasuresImporter
implements ProjectSensor {
    private static final Logger LOG = Loggers.get(MeasuresImporter.class);
    private Map<String, org.sonar.api.measures.Metric> metrics;

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Import custom FPGA measures from JSON files");
    }

    public void execute(SensorContext context) {
        this.metrics = Maps.uniqueIndex(new MetricsImporter().getMetrics(), org.sonar.api.measures.Metric::getKey);
        this.addAllMeasuresToProject(context);
        FileSystem fs = context.fileSystem();
        Iterable files = fs.inputFiles(fs.predicates().and(fs.predicates().hasLanguage("vhdl"), fs.predicates().hasType(InputFile.Type.MAIN)));
        for (InputFile file : files) {
            this.addAllMeasuresToFile(context, file);
        }
    }

    private Map<String, Object> getMeasuresFromJsonFile(String filePath) {
        try {
            return (Map)new Gson().fromJson((Reader)new FileReader(filePath), Map.class);
        }
        catch (FileNotFoundException e) {
            LOG.debug("[FPGA Metrics] No measures report found: " + filePath);
            return Collections.emptyMap();
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new IllegalStateException("[FPGA Metrics] Cannot parse JSON measures report: " + filePath);
        }
    }

    private void addAllMeasuresToProject(SensorContext context) {
        Map<String, Object> measures = this.getMeasuresFromJsonFile(context.fileSystem().baseDir().getPath() + File.separator + "measures.json");
        for (Map.Entry<String, Object> measure : measures.entrySet()) {
            this.addNewMeasure(context, null, this.getMetricFromKey(measure.getKey()), measure.getValue());
        }
    }

    private void addAllMeasuresToFile(SensorContext context, InputFile file) {
        Map<String, Object> measures = this.getMeasuresFromJsonFile(context.fileSystem().baseDir().getPath() + File.separator + FilenameUtils.removeExtension((String)file.filename()) + "_measures.json");
        for (Map.Entry<String, Object> measure : measures.entrySet()) {
            this.addNewMeasure(context, file, this.getMetricFromKey(measure.getKey()), measure.getValue());
        }
    }

    private void addNewMeasure(SensorContext context, InputFile file, org.sonar.api.measures.Metric metric, Object rawMeasure) {
        Serializable measure = this.getTypedMeasure(metric.getType().name(), this.getMeasure(rawMeasure), this.getRatioMax(rawMeasure));
        if (file != null) {
            context.newMeasure().forMetric((Metric)metric).on((InputComponent)file).withValue(measure).save();
        } else {
            context.newMeasure().forMetric((Metric)metric).on((InputComponent)context.project()).withValue(measure).save();
        }
    }

    private Object getMeasure(Object rawValue) {
        if (rawValue.getClass().equals(ArrayList.class)) {
            return ((ArrayList)rawValue).get(0);
        }
        return rawValue;
    }

    private Double getRatioMax(Object rawValue) {
        if (rawValue.getClass().equals(ArrayList.class)) {
            return (Double)((ArrayList)rawValue).get(1);
        }
        return null;
    }

    private org.sonar.api.measures.Metric getMetricFromKey(String metricKey) {
        org.sonar.api.measures.Metric metric = this.metrics.get(metricKey);
        if (metric == null) {
            throw new IllegalStateException("[FPGA Metrics] Metric with '" + metricKey + "' key cannot be found");
        }
        return metric;
    }

    private Serializable getTypedMeasure(String metricType, Object measureValue, Double ratioMax) {
        switch (metricType) {
            case "INT": {
                return Integer.valueOf((int)Math.round((Double)measureValue));
            }
            case "FLOAT": {
                return (Double)measureValue;
            }
            case "PERCENT": {
                return Double.valueOf((Double)measureValue * 100.0 / ratioMax);
            }
            case "BOOL": {
                return (Boolean)measureValue;
            }
            case "STRING": 
            case "DATA": 
            case "DISTRIB": {
                return (String)measureValue;
            }
            case "MILLISEC": 
            case "RATING": 
            case "WORK_DUR": {
                return Long.valueOf(Math.round((Double)measureValue));
            }
        }
        throw new IllegalStateException("[FPGA Metrics] '" + metricType + "' metric type not recognized.");
    }
}

