/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.fpgametrics.sensor;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.lintyservices.sonar.plugins.fpgametrics.gsondata.JsonMetric;
import com.lintyservices.sonar.plugins.fpgametrics.gsondata.JsonMetrics;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;

public class MetricsImporter
implements Metrics {
    public List<Metric> getMetrics() {
        return this.getMetricsFromJsonFile("fpgametrics/format-metrics.json", "production");
    }

    @VisibleForTesting
    List<Metric> getMetricsFromJsonFile(String jsonFilePath, String type) {
        InputStreamReader inputStreamReader;
        if ("test".equals(type)) {
            try {
                inputStreamReader = new FileReader(jsonFilePath);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("[FPGA Metrics] Cannot find JSON metrics file", e);
            }
        } else {
            inputStreamReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(jsonFilePath));
        }
        JsonMetrics jsonMetrics = (JsonMetrics)new Gson().fromJson((Reader)inputStreamReader, JsonMetrics.class);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Map.Entry<String, JsonMetric> metric : jsonMetrics.metrics().entrySet()) {
            try {
                metrics.add(this.convertToSonarQubeMetric(metric));
            }
            catch (Exception e) {
                throw new IllegalStateException("[FPGA Metrics] " + metric.getKey() + " metric cannot be created since it is not properly formatted", e);
            }
        }
        return metrics;
    }

    private Metric convertToSonarQubeMetric(Map.Entry<String, JsonMetric> metric) {
        String key = metric.getKey();
        JsonMetric value = metric.getValue();
        return new Metric.Builder(key, value.getName(), Metric.ValueType.valueOf((String)value.getType())).setDescription(value.getDescription()).setDirection(Integer.valueOf(value.getDirection())).setQualitative(Boolean.valueOf(value.isQualitative())).setDomain(value.getDomain()).setWorstValue(Double.valueOf(value.getWorstValue())).setBestValue(Double.valueOf(value.getBestValue())).setOptimizedBestValue(value.isOptimizedBestValue()).setDecimalScale(value.getDecimalScale()).setDeleteHistoricalData(value.isDeleteHistoricalData()).setHidden(value.isHidden()).setUserManaged(value.isUserManaged()).create();
    }
}

