/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.slang.helpers;

import com.google.common.annotations.VisibleForTesting;
import com.lintyservices.slang.helpers.Location;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class LocationRange
implements Comparable<LocationRange> {
    private final File file;
    private final int line;
    private final int endLine;
    private final int column;
    private final int endColumn;

    public LocationRange(Location from, Location to) {
        this.file = this.sanitizeFile(from.file());
        this.line = from.line();
        this.column = from.column();
        this.endLine = to.line();
        this.endColumn = to.column();
    }

    public LocationRange(File file, int line, int column, int endLine, int endColumn) {
        this.file = this.sanitizeFile(file);
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    @VisibleForTesting
    LocationRange(String path, int line, int column, int endLine, int endColumn) {
        this.file = new File(path);
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public File file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endColumn() {
        return this.endColumn;
    }

    public boolean isEmpty() {
        return this.endLine - this.line == 0 && this.endColumn - this.column == 0;
    }

    public Set<Integer> allLines() {
        return IntStream.rangeClosed(this.line, this.endLine).boxed().collect(Collectors.toSet());
    }

    public String markdown(File projectBaseDir) {
        return this.markdown(null, projectBaseDir);
    }

    public String markdown(@Nullable String text, File projectBaseDir) {
        String name = this.file.getName();
        String display = text != null ? text : name + "#" + this.line;
        String link = String.format("%s#%s", projectBaseDir.toPath().relativize(this.file.toPath()), this.line);
        return String.format("<linty-anchor href=\"/%s\">%s</linty-anchor>", link, display);
    }

    public String toString() {
        return this.file.getAbsolutePath() + ":" + this.line + ":" + this.column + " - " + this.endLine + ":" + this.endColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationRange)) {
            return false;
        }
        LocationRange l = (LocationRange)o;
        return l.file().equals(this.file) && l.line() == this.line && l.column() == this.column && l.endLine() == this.endLine && l.endColumn() == this.endColumn;
    }

    @Override
    public int compareTo(LocationRange o) {
        if (this.file.getAbsolutePath().compareTo(o.file().getAbsolutePath()) > 0) {
            return 1;
        }
        if (this.file.getAbsolutePath().compareTo(o.file().getAbsolutePath()) < 0) {
            return -1;
        }
        if (this.line > o.line()) {
            return 1;
        }
        if (this.line < o.line()) {
            return -1;
        }
        if (this.column > o.column()) {
            return 1;
        }
        if (this.column < o.column()) {
            return -1;
        }
        if (this.endLine > o.endLine()) {
            return 1;
        }
        if (this.endLine < o.endLine()) {
            return -1;
        }
        if (this.endColumn > o.endColumn()) {
            return 1;
        }
        if (this.endColumn < o.endColumn()) {
            return -1;
        }
        return 0;
    }

    private File sanitizeFile(File file) {
        String sanitizedPath;
        try {
            sanitizedPath = Pattern.compile("^([a-zA-Z]+):\\\\").matcher(file.getCanonicalPath()).replaceFirst(m -> m.group(1).toLowerCase() + ":\\\\");
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get canonical path from " + file.getAbsolutePath(), e);
        }
        return new File(sanitizedPath);
    }
}

