/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.slang.helpers;

import com.lintyservices.slang.api.SlangParser;
import com.lintyservices.slang.helpers.Located;
import com.lintyservices.slang.helpers.LocationRange;
import com.lintyservices.slang.helpers.SyntaxKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class SyntaxNode {
    private SlangParser parser;
    private boolean is_token;
    private long ref;

    public native int children();

    public native SyntaxNode child(int var1);

    public native SyntaxNode parent();

    public native LocationRange location();

    public native LocationRange originalLocation();

    private boolean isToken() {
        return this.is_token;
    }

    @Nullable
    private native List<Trivia> getTrivia();

    @Nullable
    private native List<Trivia> getFlattenedTrivia();

    public List<Trivia> getLineComments() {
        List<Trivia> trivia = this.getFlattenedTrivia();
        if (trivia != null) {
            return this.getFlattenedTrivia().stream().filter(t -> t.kind() == TriviaKind.LineComment && !t.isPreprocessed()).sorted(Comparator.comparing(Trivia::location)).collect(Collectors.toList());
        }
        return new ArrayList<Trivia>();
    }

    public List<Trivia> getBlockComments() {
        List<Trivia> trivia = this.getFlattenedTrivia();
        if (trivia != null) {
            return this.getFlattenedTrivia().stream().filter(t -> t.kind() == TriviaKind.BlockComment && !t.isPreprocessed()).sorted(Comparator.comparing(Trivia::location)).collect(Collectors.toList());
        }
        return new ArrayList<Trivia>();
    }

    public List<Trivia> getComments() {
        List<Trivia> all = this.getLineComments();
        all.addAll(this.getBlockComments());
        return all.stream().sorted(Comparator.comparing(Trivia::location)).toList();
    }

    public List<SyntaxNode> getDirectives() {
        List<Trivia> trivia = this.getTrivia();
        if (trivia != null) {
            return this.getTrivia().stream().filter(t -> t.kind() == TriviaKind.Directive && !t.isPreprocessed()).map(Trivia::node).sorted(Comparator.comparing(SyntaxNode::location)).collect(Collectors.toList());
        }
        return new ArrayList<SyntaxNode>();
    }

    public List<SyntaxNode> getTokensAndDirectives() {
        List<SyntaxNode> all = this.getAllTokens();
        all.addAll(this.getDirectives());
        return all.stream().sorted(Comparator.comparing(SyntaxNode::location)).toList();
    }

    public SyntaxNode getFirstToken() {
        return this.getAllTokens().get(0);
    }

    public native boolean isPreprocessed();

    public native List<SyntaxNode> getAllTokens();

    public native boolean isKeywordToken();

    public native SyntaxKind kind();

    public native String valueText();

    public native String textDetail(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public String text() {
        return this.textDetail(false, true, true, true, false).trim();
    }

    public String textUntrimmed() {
        return this.textDetail(false, true, true, true, true);
    }

    public String textUnprocessed() {
        return this.textDetail(true, true, true, false, true);
    }

    @Nullable
    public SyntaxNode ancestor(SyntaxKind ... kinds) {
        if (this.parent() != null) {
            if (Arrays.stream(kinds).toList().contains(this.parent().kind())) {
                return this.parent();
            }
            return this.parent().ancestor(kinds);
        }
        return null;
    }

    public boolean hasAncestor(SyntaxKind ... kinds) {
        return ((Stream)Arrays.stream(kinds).sequential()).map(this::hasAncestor).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean hasAncestor(SyntaxKind kind) {
        if (this.parent() != null) {
            if (this.parent().kind() == kind) {
                return true;
            }
            return this.parent().hasAncestor(kind);
        }
        return false;
    }

    public native List<SyntaxNode> search(SyntaxKind[] var1);

    public native List<SyntaxNode> searchNonrecursive(SyntaxKind[] var1);

    public <E> List<E> search(SyntaxKind query, Function<SyntaxNode, E> factory2) {
        List<SyntaxNode> nodes = this.search(query);
        ArrayList<E> output = new ArrayList<E>();
        for (SyntaxNode node : nodes) {
            output.add(factory2.apply(node));
        }
        return output;
    }

    public List<SyntaxNode> search(SyntaxKind query) {
        return this.search(new SyntaxKind[]{query});
    }

    public List<SyntaxNode> searchNonrecursive(SyntaxKind query) {
        return this.searchNonrecursive(new SyntaxKind[]{query});
    }

    public void printTree() {
        this.printTree(this, 0, 0);
    }

    private void printTree(SyntaxNode node, int index, int indentation) {
        String toPrint = "-".repeat(indentation) + "(" + index + ") " + (node.kind() != null ? String.format("%s", node.kind()) : (node.isToken() ? "Token" : "")) + (String)(!"".equals(node.text()) ? ": " + node.text() : "") + (String)(node.location() != null ? " (" + String.valueOf(node.location()) + ")" : "");
        System.out.println(toPrint);
        for (int i = 0; i < node.children(); ++i) {
            if (node.child(i) == null) continue;
            this.printTree(node.child(i), i, indentation + 4);
        }
    }

    public class Trivia
    implements Located {
        private TriviaKind kind;
        private boolean preprocessed;
        private String rawText;
        private SyntaxNode syntax;
        private LocationRange location;

        @Override
        public LocationRange location() {
            return this.location;
        }

        public String text() {
            return this.rawText;
        }

        public boolean isPreprocessed() {
            return this.preprocessed;
        }

        public TriviaKind kind() {
            return this.kind;
        }

        @Nullable
        public SyntaxNode node() {
            return this.syntax;
        }
    }

    public static enum TriviaKind {
        Unknown,
        Whitespace,
        EndOfLine,
        LineComment,
        BlockComment,
        DisabledText,
        SkippedTokens,
        SkippedSyntax,
        Directive;

    }
}

