/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.slang.trees;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.helpers.Tree;
import com.lintyservices.slang.trees.DefaultCaseItem;
import com.lintyservices.slang.trees.StandardCaseItem;
import java.util.List;

public abstract class GenericCaseStatement
extends Tree {
    private final List<SyntaxNode> caseItems = this.gatherCaseItems();

    public GenericCaseStatement(SyntaxNode node) {
        super(node);
    }

    public abstract SyntaxNode caseKeyword();

    public boolean hasDefaultCaseItem() {
        return this.caseItems.stream().anyMatch(i -> i.kind() == SyntaxKinds.DefaultCaseItem);
    }

    public boolean isDefaultLastCaseItem() {
        if (!this.hasDefaultCaseItem()) {
            return true;
        }
        return this.caseItems.get(this.caseItems.size() - 1).kind() == SyntaxKinds.DefaultCaseItem;
    }

    public List<DefaultCaseItem> defaultCaseItems() {
        return this.caseItems.stream().filter(i -> i.kind() == SyntaxKinds.DefaultCaseItem).map(DefaultCaseItem::new).toList();
    }

    public List<StandardCaseItem> standardCaseItems() {
        return this.caseItems.stream().filter(i -> i.kind() == SyntaxKinds.StandardCaseItem).map(StandardCaseItem::new).toList();
    }

    public abstract List<SyntaxNode> gatherCaseItems();
}

