/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.bugfinder.BugFinder;
import com.lintyservices.sonar.plugins.bugfinder.BugFinderOutput;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.HdlCheckList;
import com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder.UnregisteredLowLevelInputPortsCheck;
import com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder.UnregisteredTopLevelInputPortsCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.verilog.checks.VerilogCheckList;
import com.lintyservices.sonar.plugins.vhdl.checks.VhdlCheckList;
import com.lintyservices.utils.LintyException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"bug-finder"})
@DependsUpon(value={"license"})
public class BugFinderSensor
implements Sensor {
    private final List<Check> checks;
    private final Configuration config;
    @Nullable
    private BugFinderOutput bugFinderOutput;

    public BugFinderSensor(CheckFactory checkFactory, Configuration config) {
        this.config = config;
        this.checks = new Checks(checkFactory).registerCheckClasses("vhdl", VhdlCheckList.getChecks()).registerCheckClasses("verilog", VerilogCheckList.getChecks()).registerCheckClasses("hdl", HdlCheckList.getChecks()).allChecks();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("BugFinder").onlyOnLanguages(new String[]{"vhdl", "verilog"});
    }

    public void execute(SensorContext context) {
        if (!Product.bugFinder(this.config) && !this.bugFinderVisitors().isEmpty()) {
            throw new LintyException("BugFinder rules are activated but BugFinder is not enabled. Either activate BugFinder or deactivate BugFinder rules.");
        }
        if (!Product.hdlDesigner(context) && Product.bugFinder(this.config)) {
            try {
                BugFinder bugFinder = new BugFinder(context);
                this.setNumberOfInputRegistrations(bugFinder);
                this.bugFinderOutput = bugFinder.execute();
            }
            catch (Exception e) {
                throw new LintyException("[BugFinder] Failed to execute", e);
            }
        }
    }

    @Nullable
    public BugFinderOutput bugFinderOutput() {
        return this.bugFinderOutput;
    }

    private Set<BugFinderVisitor> bugFinderVisitors() {
        return this.checks.stream().filter(BugFinderVisitor.class::isInstance).map(BugFinderVisitor.class::cast).collect(Collectors.toSet());
    }

    private void setNumberOfInputRegistrations(BugFinder bugFinder) {
        this.checks.stream().filter(UnregisteredTopLevelInputPortsCheck.class::isInstance).findFirst().ifPresent(check2 -> bugFinder.setNumberOfTopLevelInputRegistrations(((UnregisteredTopLevelInputPortsCheck)check2).min));
        this.checks.stream().filter(UnregisteredLowLevelInputPortsCheck.class::isInstance).findFirst().ifPresent(check2 -> bugFinder.setNumberOfLowLevelInputRegistrations(((UnregisteredLowLevelInputPortsCheck)check2).min));
    }
}

