/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins;

import com.lintyservices.sonar.plugins.Product;
import com.lintyservices.sonar.plugins.hdl.LintyPaths;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

@DependedUpon(value={"init"})
public class InitSensor
implements Sensor {
    private final Configuration config;

    public InitSensor(Configuration config) {
        this.config = config;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Init").onlyOnLanguages(new String[]{"vhdl", "verilog", "hdl"});
    }

    public void execute(SensorContext context) {
        if (Product.hdlDesigner(context)) {
            return;
        }
        File workDir = new LintyPaths(this.config).workDir();
        try {
            org.apache.commons.io.FileUtils.deleteDirectory(workDir);
            Files.createDirectories(workDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LintyException("Cannot delete working directory: " + FileUtils.sanitizedPath(workDir.getAbsolutePath()), e);
        }
    }
}

