/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.bugfinder;

import com.google.common.annotations.VisibleForTesting;
import com.lintyservices.sonar.plugins.hdl.LintyPaths;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.VerificLogItem;
import com.lintyservices.yosys.objects.YosysCDC;
import com.lintyservices.yosys.objects.YosysCell;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysClockUsage;
import com.lintyservices.yosys.objects.YosysCombinationalLoop;
import com.lintyservices.yosys.objects.YosysConnectedPorts;
import com.lintyservices.yosys.objects.YosysCustomMetrics;
import com.lintyservices.yosys.objects.YosysEnableUsage;
import com.lintyservices.yosys.objects.YosysFsm;
import com.lintyservices.yosys.objects.YosysModuleInstantiation;
import com.lintyservices.yosys.objects.YosysPort;
import com.lintyservices.yosys.objects.YosysPortClockDomains;
import com.lintyservices.yosys.objects.YosysRDC;
import com.lintyservices.yosys.objects.YosysResetDomain;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import com.lintyservices.yosys.objects.YosysResetUsage;
import com.lintyservices.yosys.objects.YosysSynthesizedObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.sonar.api.config.Configuration;

public class BugFinderOutput {
    public Set<YosysCDC> cdcs;
    public Set<YosysRDC> rdcs;
    public Set<YosysClockDomain> clockDomains;
    public Set<YosysResetDomain> resetDomains;
    public YosysClockManagementModule clockManagementModule;
    public YosysResetManagementModule resetManagementModule;
    public Set<YosysClockUsage> clocks;
    public Set<YosysCombinationalLoop> combinationalLoops;
    public Set<YosysPort> constantOutputPorts;
    public YosysCustomMetrics customMetrics;
    public YosysModuleInstantiation designHierarchy;
    public Set<YosysConnectedPorts> directlyConnectedPorts;
    public Set<YosysEnableUsage> enables;
    public Set<YosysCell> flipFlopsNoReset;
    public Set<YosysFsm> fsms;
    public Set<YosysResetUsage> resets;
    public Set<YosysSynthesizedObject> synthesizedObjects;
    public Set<YosysPortClockDomains> topLevelInputPortsMultipleClockDomains;
    public Set<YosysPort> unconnectedPorts;
    public Set<YosysPort> unregisteredOutputPorts;
    public Set<YosysPort> unregisteredLowLevelInputPorts;
    public Set<YosysPort> unregisteredTopLevelInputPorts;
    public Set<VerificLogItem> verificLogItems;
    private final String yosysBuildDir;
    private final File bugFinderWorkDir;
    private final File bugFinderLogOutput;

    public BugFinderOutput(Configuration config) {
        LintyPaths lintyPaths = new LintyPaths(config);
        this.yosysBuildDir = lintyPaths.baseDir().getAbsolutePath();
        this.bugFinderWorkDir = lintyPaths.bugfinderWorkDir();
        this.bugFinderLogOutput = new File(this.bugFinderWorkDir.getAbsolutePath() + "/logs/output.log");
        this.load();
    }

    @VisibleForTesting
    public BugFinderOutput(File bugFinderWorkDir, File bugFinderLogOutput) {
        this.yosysBuildDir = "";
        this.bugFinderWorkDir = bugFinderWorkDir;
        this.bugFinderLogOutput = bugFinderLogOutput;
    }

    public Set<YosysCDC> cdcs() {
        return this.cdcs;
    }

    public Set<YosysRDC> rdcs() {
        return this.rdcs;
    }

    public Set<YosysClockDomain> clockDomains() {
        return this.clockDomains;
    }

    public Set<YosysResetDomain> resetDomains() {
        return this.resetDomains;
    }

    public YosysClockManagementModule clockManagementModule() {
        return this.clockManagementModule;
    }

    public YosysResetManagementModule resetManagementModule() {
        return this.resetManagementModule;
    }

    public Set<YosysClockUsage> clocks() {
        return this.clocks;
    }

    public Set<YosysCombinationalLoop> combinationalLoops() {
        return this.combinationalLoops;
    }

    public Set<YosysPort> constantOutputPorts() {
        return this.constantOutputPorts;
    }

    public YosysCustomMetrics customMetrics() {
        return this.customMetrics;
    }

    public YosysModuleInstantiation designHierarchy() {
        return this.designHierarchy;
    }

    public Set<YosysConnectedPorts> directlyConnectedPorts() {
        return this.directlyConnectedPorts;
    }

    public Set<YosysEnableUsage> enables() {
        return this.enables;
    }

    public Set<YosysCell> flipFlopsNoReset() {
        return this.flipFlopsNoReset;
    }

    public Set<YosysFsm> fsms() {
        return this.fsms;
    }

    public Set<YosysResetUsage> resets() {
        return this.resets;
    }

    public Set<YosysSynthesizedObject> synthesizedObjects() {
        return this.synthesizedObjects;
    }

    public Set<YosysPortClockDomains> topLevelInputPortsMultipleClockDomains() {
        return this.topLevelInputPortsMultipleClockDomains;
    }

    public Set<YosysPort> unconnectedPorts() {
        return this.unconnectedPorts;
    }

    public Set<YosysPort> unregisteredOutputPorts() {
        return this.unregisteredOutputPorts;
    }

    public Set<YosysPort> unregisteredTopLevelInputPorts() {
        return this.unregisteredTopLevelInputPorts;
    }

    public Set<YosysPort> unregisteredLowLevelInputPorts() {
        return this.unregisteredLowLevelInputPorts;
    }

    public Set<VerificLogItem> verificLogItems() {
        return this.verificLogItems;
    }

    private void load() {
        this.cdcs = this.loadCDCs();
        this.rdcs = this.loadRDCs();
        this.clockDomains = this.loadClockDomains();
        this.resetDomains = this.loadResetDomains();
        this.clockManagementModule = this.loadClockManagementModule();
        this.resetManagementModule = this.loadResetManagementModule();
        this.clocks = this.loadClocks();
        this.combinationalLoops = this.loadCombinationalLoops();
        this.constantOutputPorts = this.loadConstantOutputPorts();
        this.customMetrics = this.loadCustomMetrics();
        this.designHierarchy = this.loadDesignHierarchy();
        this.directlyConnectedPorts = this.loadDirectlyConnectedPorts();
        this.enables = this.loadEnables();
        this.flipFlopsNoReset = this.loadFlipFlopsNoReset();
        this.fsms = this.loadFsms();
        this.resets = this.loadResets();
        this.synthesizedObjects = this.loadSynthesizedObjects();
        this.unconnectedPorts = this.loadUnconnectedPorts();
        this.unregisteredOutputPorts = this.loadUnregisteredOutputPorts();
        this.unregisteredLowLevelInputPorts = this.loadUnregisteredInputPorts("unregistered_low_level_input_ports.json");
        this.unregisteredTopLevelInputPorts = this.loadUnregisteredInputPorts("unregistered_top_level_input_ports.json");
        this.topLevelInputPortsMultipleClockDomains = this.loadTopLevelInputPortsMultipleClockDomains();
        this.verificLogItems = this.loadVerificLogItems();
    }

    @VisibleForTesting
    public Set<YosysCDC> loadCDCs() {
        String json = this.loadJsonFromFile("cdcs.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysCDC((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysCDC>();
    }

    @VisibleForTesting
    public Set<YosysRDC> loadRDCs() {
        String json = this.loadJsonFromFile("rdcs.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysRDC((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysRDC>();
    }

    @VisibleForTesting
    public Set<YosysClockDomain> loadClockDomains() {
        String json = this.loadJsonFromFile("clock_domains.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysClockDomain((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysClockDomain>();
    }

    @VisibleForTesting
    public Set<YosysResetDomain> loadResetDomains() {
        String json = this.loadJsonFromFile("reset_domains.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysResetDomain((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysResetDomain>();
    }

    @Nullable
    @VisibleForTesting
    public YosysClockManagementModule loadClockManagementModule() {
        String json = this.loadJsonFromFile("cmm.json", false);
        if (json != null) {
            return new YosysClockManagementModule(new JSONObject(json).toMap(), this.yosysBuildDir);
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    public YosysResetManagementModule loadResetManagementModule() {
        String json = this.loadJsonFromFile("rmm.json", false);
        if (json != null) {
            return new YosysResetManagementModule(new JSONObject(json).toMap(), this.yosysBuildDir);
        }
        return null;
    }

    @VisibleForTesting
    public Set<YosysClockUsage> loadClocks() {
        String json = this.loadJsonFromFile("clocks.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysClockUsage((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysClockUsage>();
    }

    @VisibleForTesting
    public Set<YosysCombinationalLoop> loadCombinationalLoops() {
        String json = this.loadJsonFromFile("combinational_loops.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysCombinationalLoop((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysCombinationalLoop>();
    }

    @VisibleForTesting
    public Set<YosysPort> loadConstantOutputPorts() {
        String json = this.loadJsonFromFile("constant_output_ports.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysPort((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysPort>();
    }

    @VisibleForTesting
    public YosysCustomMetrics loadCustomMetrics() {
        String json = this.loadJsonFromFile("custom_metrics.json");
        if (json != null) {
            return new YosysCustomMetrics(new JSONObject(json).toMap());
        }
        throw new LintyException("[BugFinder] Custom metrics have not been computed.");
    }

    @VisibleForTesting
    public YosysModuleInstantiation loadDesignHierarchy() {
        String json = this.loadJsonFromFile("design_hierarchy.json");
        if (json != null) {
            return new YosysModuleInstantiation(new JSONObject(json).toMap(), this.yosysBuildDir);
        }
        throw new LintyException("[BugFinder] Design hierarchy has not been computed.");
    }

    @VisibleForTesting
    public Set<YosysConnectedPorts> loadDirectlyConnectedPorts() {
        String json = this.loadJsonFromFile("directly_connected_ports.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysConnectedPorts((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysConnectedPorts>();
    }

    @VisibleForTesting
    public Set<YosysEnableUsage> loadEnables() {
        String json = this.loadJsonFromFile("enables.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysEnableUsage((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysEnableUsage>();
    }

    @VisibleForTesting
    public Set<YosysCell> loadFlipFlopsNoReset() {
        String json = this.loadJsonFromFile("ff_no_reset.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysCell((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysCell>();
    }

    @VisibleForTesting
    public Set<YosysFsm> loadFsms() {
        String json = this.loadJsonFromFile("fsms.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysFsm((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysFsm>();
    }

    @VisibleForTesting
    public Set<YosysResetUsage> loadResets() {
        String json = this.loadJsonFromFile("resets.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysResetUsage((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysResetUsage>();
    }

    @VisibleForTesting
    public Set<YosysSynthesizedObject> loadSynthesizedObjects() {
        String json = this.loadJsonFromFile("synthesized_objects.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysSynthesizedObject((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysSynthesizedObject>();
    }

    @VisibleForTesting
    public Set<YosysPort> loadUnconnectedPorts() {
        String json = this.loadJsonFromFile("unconnected_ports.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysPort((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysPort>();
    }

    @VisibleForTesting
    public Set<YosysPort> loadUnregisteredOutputPorts() {
        String json = this.loadJsonFromFile("unregistered_output_ports.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysPort((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysPort>();
    }

    @VisibleForTesting
    public Set<YosysPort> loadUnregisteredInputPorts(String fileName) {
        String json = this.loadJsonFromFile(fileName, false);
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysPort((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysPort>();
    }

    @VisibleForTesting
    public Set<YosysPortClockDomains> loadTopLevelInputPortsMultipleClockDomains() {
        String json = this.loadJsonFromFile("top_input_ports_multiple_clock_domains.json");
        if (json != null) {
            return new JSONArray(json).toList().stream().map(Map.class::cast).map(o -> new YosysPortClockDomains((Map<String, Object>)o, this.yosysBuildDir)).collect(Collectors.toSet());
        }
        return new HashSet<YosysPortClockDomains>();
    }

    @VisibleForTesting
    public Set<VerificLogItem> loadVerificLogItems() {
        Set<VerificLogItem> set;
        block8: {
            Stream<String> input = Files.lines(this.bugFinderLogOutput.toPath());
            try {
                set = input.filter(l -> VerificLogItem.MESSAGE_WITH_ID.matcher((CharSequence)l).matches()).map(l -> new VerificLogItem((String)l, this.yosysBuildDir)).collect(Collectors.toSet());
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LintyException("[BugFinder] " + FileUtils.sanitizedPath(this.bugFinderLogOutput.getAbsolutePath()) + " cannot be read.", e);
                }
            }
            input.close();
        }
        return set;
    }

    private String loadJsonFromFile(String filename) {
        return this.loadJsonFromFile(filename, true);
    }

    @Nullable
    private String loadJsonFromFile(String filename, boolean failIfNotFound) {
        File file = new File(this.bugFinderWorkDir.getAbsolutePath() + File.separator + filename);
        try {
            return Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            if (failIfNotFound) {
                throw new LintyException("[BugFinder] " + FileUtils.sanitizedPath(file.getAbsolutePath()) + " has not been generated.", e);
            }
            return null;
        }
    }
}

