/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.clock.CDCs;
import com.lintyservices.sonar.plugins.hdl.graph.logiccircuit.CDCLogicCircuitGraph;
import com.lintyservices.yosys.objects.YosysCDC;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.api.config.Configuration;

public class CDCsReport
extends Report {
    private final CDCs cdcs;

    public CDCsReport(CDCs cdcs, Configuration config) {
        super(config);
        this.cdcs = cdcs;
    }

    @Override
    public String fileName() {
        return "clock_domain_crossings.md";
    }

    @Override
    public String title() {
        return "Clock Domain Crossings (CDC)";
    }

    @Override
    public String summary() {
        return "CDCs: " + this.cdcs.size();
    }

    @Override
    public void generate() {
        Map<String, List<YosysCDC>> cdcsAsMap = this.cdcs.asMap();
        this.generateMainReport(cdcsAsMap);
        this.generateDetailedReports(cdcsAsMap);
        this.generateLogicCircuitGraphs();
    }

    private void generateMainReport(Map<String, List<YosysCDC>> cdcsAsMap) {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(this.cdcs.size()).append("**\n\n");
        if (this.cdcs.size() > 0) {
            data.append(this.allCdcsSummary(cdcsAsMap));
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateDetailedReports(Map<String, List<YosysCDC>> cdcsAsMap) {
        new File(String.valueOf(this.reportsDir()) + File.separator + "cdcs").mkdirs();
        for (Map.Entry<String, List<YosysCDC>> entry : cdcsAsMap.entrySet()) {
            StringBuilder data = new StringBuilder();
            data.append("# ").append(entry.getKey().replace(";", " => ")).append("\n\n").append(this.cdcSummary(entry)).append("\n\n## CDCs\n\n").append("\n\n### Summary\n\n").append("|ID|Graph|Origin Signal|Target Signal|Details|\n|---:|:---:|---|---|:---:|\n");
            entry.getValue().forEach(cdc -> data.append("|").append(cdc.id()).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|").append("`").append(String.join((CharSequence)"`, `", cdc.origin().qPublicNames())).append("`").append("|").append("`").append(String.join((CharSequence)"`, `", cdc.target().qPublicNames())).append("`").append("|").append(this.linkToDetails("View CDC Details", "#cdc-" + cdc.id())).append("|\n"));
            entry.getValue().forEach(cdc -> data.append(this.getCdcDetails((YosysCDC)cdc)));
            this.writeChildReport(this.addBackLinks(data.toString(), "Back to Clock Domain Crossings (CDC) Report", "clock_domain_crossings.html"), "cdcs/cdcs_" + entry.getKey() + ".md");
        }
    }

    private String getCdcDetails(YosysCDC cdc) {
        String header = "|Graph|Signal|Clock Domain|Flip-flop|\n|:---:|---|---|---|\n";
        StringBuilder data = new StringBuilder().append("### CDC #").append(cdc.id()).append("\n\n").append("#### Origin Flip-flop\n\n").append(header).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|");
        String originClockDomainDisplay = cdc.origin().clockDomainUsage().clockDomain().name() + " (" + cdc.origin().clockDomainUsage().direction().value() + ")";
        data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.origin().qPublicNames())).append("`").append("<br>Usage:<br>- ").append(this.cdcs.dcUtils().signalsToMarkdown(cdc.origin())).append("|").append(cdc.origin().clockDomainUsage().clockDomain().location().markdown(originClockDomainDisplay)).append("|").append(cdc.origin().cell().scopes() != null ? cdc.origin().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(cdc.origin().cell().location().markdown()).append("|\n\n\n").append("#### Target Flip-flop\n\n").append(header).append("|").append(this.linkToGraph("Open CDC Graph", "cdcs/cdc_" + cdc.id())).append("|");
        String targetClockDomainDisplay = cdc.target().clockDomainUsage().clockDomain().name() + " (" + cdc.target().clockDomainUsage().direction().value() + ")";
        data.append("Signal: `").append(String.join((CharSequence)"`, `", cdc.target().qPublicNames())).append("`").append("<br>Usage:<br>- ").append(this.cdcs.dcUtils().signalsToMarkdown(cdc.target())).append("|").append(cdc.target().clockDomainUsage().clockDomain().location().markdown(targetClockDomainDisplay)).append("|").append(cdc.target().cell().scopes() != null ? cdc.target().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(cdc.target().cell().location().markdown()).append("|\n");
        return data.toString();
    }

    private String allCdcsSummary(Map<String, List<YosysCDC>> cdcsAsMap) {
        StringBuilder data = new StringBuilder();
        data.append("|Origin Clock Domain|Target Clock Domain|Number of CDCs|Graph|Details|\n|---|---|---:|:---:|:---:|\n");
        cdcsAsMap.keySet().stream().sorted().forEach(key -> {
            YosysCDC cdc = (YosysCDC)((List)cdcsAsMap.get(key)).get(0);
            data.append("|").append(cdc.origin().clockDomainUsage().clockDomain().location().markdown(cdc.fullOriginClockDomain())).append("|").append(cdc.target().clockDomainUsage().clockDomain().location().markdown(cdc.fullTargetClockDomain())).append("|").append(((List)cdcsAsMap.get(key)).size()).append("|").append(this.linkToGraph("Open CDCs Graph", "cdcs/cdcs_" + key)).append("|").append(this.linkToDetails("View CDCs Details", "cdcs/cdcs_" + key + ".html")).append("|\n");
        });
        return data.toString();
    }

    private String cdcSummary(Map.Entry<String, List<YosysCDC>> cdcs) {
        StringBuilder data = new StringBuilder();
        data.append("|Origin Clock Domain|Target Clock Domain|Number of CDCs|Graph|\n|---|---|---:|:---:|\n");
        YosysCDC firstCdc = cdcs.getValue().get(0);
        data.append("|").append(firstCdc.origin().clockDomainUsage().clockDomain().location().markdown(firstCdc.fullOriginClockDomain())).append("|").append(firstCdc.target().clockDomainUsage().clockDomain().location().markdown(firstCdc.fullTargetClockDomain())).append("|").append(cdcs.getValue().size()).append("|").append(this.linkToGraph("Open CDCs Graph", "cdcs/cdcs_" + cdcs.getKey())).append("|\n");
        return data.toString();
    }

    private void generateLogicCircuitGraphs() {
        Path bugFinderGraphPath = Path.of(String.valueOf(this.bugfinderWorkDir()) + File.separator + "cdcs", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            if (bugFinderGraphPath.toFile().listFiles() == null) {
                return;
            }
            File cdcsdirectory = new File(String.valueOf(this.graphsDir()) + File.separator + "cdcs");
            cdcsdirectory.mkdirs();
            for (File file : Arrays.stream(bugFinderGraphPath.toFile().listFiles()).filter(f -> f.getName().endsWith("json")).toList()) {
                String fileNameWithoutExtension = file.getName().substring(0, file.getName().length() - 5);
                String id = fileNameWithoutExtension.split("_", 2)[1].replace(";", " => ");
                this.writeGraph(new CDCLogicCircuitGraph(file, "CDC: " + id), fileNameWithoutExtension, "cdcs");
            }
        }
    }
}

