/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.combinationalloop.CombinationalLoops;
import com.lintyservices.sonar.plugins.hdl.graph.logiccircuit.CombinationalLoopCircuitGraph;
import com.lintyservices.yosys.objects.YosysCombinationalLoop;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import org.sonar.api.config.Configuration;

public class CombinationalLoopsReport
extends Report {
    private final CombinationalLoops loops;

    public CombinationalLoopsReport(CombinationalLoops loops, Configuration config) {
        super(config);
        this.loops = loops;
    }

    @Override
    public String fileName() {
        return "combinational_loops.md";
    }

    @Override
    public String title() {
        return "Combinational Loops";
    }

    @Override
    public String summary() {
        return "Loops: " + this.loops.size();
    }

    @Override
    public void generate() {
        this.generateMainReport();
        this.generateLogicCircuitGraphs();
    }

    private void generateMainReport() {
        int numberOfLoops = this.loops.size();
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(numberOfLoops).append("**\n\n");
        if (numberOfLoops > 0) {
            data.append("|ID|Graph|Signal|\n").append("|---|:---:|---|\n");
            for (YosysCombinationalLoop loop : this.loops.combinationalLoops()) {
                data.append("|").append(loop.id()).append("|").append(this.linkToGraph("Open Combinational Loop Graph", "combinational_loops/combinational_loop_" + loop.id())).append("|").append(loop.signal().name()).append(": ").append(loop.signal().location().markdown()).append("|`").append("\n");
            }
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateLogicCircuitGraphs() {
        Path bugFinderGraphPath = Path.of(String.valueOf(this.bugfinderWorkDir()) + File.separator + "combinational_loops", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            if (bugFinderGraphPath.toFile().listFiles() == null) {
                return;
            }
            File rdcsDirectory = new File(String.valueOf(this.graphsDir()) + File.separator + "combinational_loops");
            rdcsDirectory.mkdirs();
            for (File file : Arrays.stream(bugFinderGraphPath.toFile().listFiles()).filter(f -> f.getName().endsWith("json")).toList()) {
                String id = file.getName().split("\\.")[0];
                String i = file.getName().split("_")[2].split("\\.")[0];
                this.writeGraph(new CombinationalLoopCircuitGraph(file, "Combinational Loop #" + i), id, "combinational_loops");
            }
        }
    }
}

