/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.lintyservices.sonar.plugins.hdl.Report;
import com.lintyservices.sonar.plugins.hdl.graph.logiccircuit.RDCLogicCircuitGraph;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.RDCs;
import com.lintyservices.yosys.objects.YosysRDC;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.api.config.Configuration;

public class RDCsReport
extends Report {
    private final RDCs rdcs;

    public RDCsReport(RDCs rdcs, Configuration config) {
        super(config);
        this.rdcs = rdcs;
    }

    @Override
    public String fileName() {
        return "reset_domain_crossings.md";
    }

    @Override
    public String title() {
        return "Reset Domain Crossings (RDC)";
    }

    @Override
    public String summary() {
        return "RDCs: " + this.rdcs.size();
    }

    @Override
    public void generate() {
        Map<String, List<YosysRDC>> rdcsAsMap = this.rdcs.asMap();
        this.generateMainReport(rdcsAsMap);
        this.generateDetailedReports(rdcsAsMap);
        this.generateLogicCircuitGraphs();
    }

    private void generateMainReport(Map<String, List<YosysRDC>> rdcsAsMap) {
        StringBuilder data = new StringBuilder().append("# ").append(this.title()).append("\n\n").append("Count: **").append(this.rdcs.size()).append("**\n\n");
        if (this.rdcs.size() > 0) {
            data.append(this.allRdcsSummary(rdcsAsMap));
        }
        this.writeMainReport(data.toString(), this.fileName());
    }

    private void generateDetailedReports(Map<String, List<YosysRDC>> rdcsAsMap) {
        new File(String.valueOf(this.reportsDir()) + File.separator + "rdcs").mkdirs();
        for (Map.Entry<String, List<YosysRDC>> entry : rdcsAsMap.entrySet()) {
            StringBuilder data = new StringBuilder();
            data.append("# ").append(entry.getKey().replace(";", " => ")).append("\n\n").append("Graph: ").append(this.linkToGraph("Open RDCs Graph", "rdcs/rdcs_" + entry.getKey())).append("\n\n").append("Count: **").append(entry.getValue().size()).append("**\n\n").append("|ID|Graph|Reset (source)|Flip-flop (destination)|\n|---|---|---|---|\n");
            entry.getValue().forEach(rdc -> {
                data.append(rdc.id()).append("|").append(this.linkToGraph("Open RDC Graph", "rdcs/rdc_" + rdc.id())).append("|").append("Clock domain: ").append(rdc.origin().clockDomainUsage().clockDomain().location().markdown(rdc.fullOriginClockDomain())).append("<br>").append("<br>Reset: ");
                Map<String, HdlIssueLocation> originLocations = this.rdcs.clockAndResetDomainUtils().originLocationsAsMap(rdc.reset());
                if (originLocations.size() > 1) {
                    data.append(rdc.reset().location() != null ? rdc.reset().location().markdown(rdc.reset().name()) : "Complex");
                }
                for (String key : originLocations.keySet().stream().sorted().toList()) {
                    if (originLocations.size() > 1) {
                        data.append("<br>&nbsp;&nbsp;-&nbsp;");
                    }
                    data.append(key).append(": ").append(originLocations.get(key).markdownWithLocationDisplay(this.config(), originLocations.get(key).message().replace(" origin", "").replaceAll("Port:.+", "Port")));
                }
                data.append("|").append("Clock domain: ").append(rdc.target().clockDomainUsage().clockDomain().location().markdown(rdc.fullTargetClockDomain())).append("<br><br>").append("Flip-flop: ").append(rdc.target().cell().scopes() != null ? rdc.target().cell().scopes().instantiationPathAsMarkdown() : "").append(" > ").append(rdc.target().cell().location().markdown()).append("|").append("\n");
            });
            this.writeChildReport(this.addBackLinks(data.toString(), "Back to Reset Domain Crossings (RDC) Report", "reset_domain_crossings.html"), "rdcs/rdcs_" + entry.getKey() + ".md");
        }
    }

    private String allRdcsSummary(Map<String, List<YosysRDC>> rdcsAsMap) {
        StringBuilder data = new StringBuilder();
        data.append("|Reset (source)|Flip-flop (destination)|Number of RDCs|Graph|Details|\n|---|---|---|---|---|\n");
        rdcsAsMap.keySet().stream().sorted().forEach(key -> {
            YosysRDC rdc = (YosysRDC)((List)rdcsAsMap.get(key)).get(0);
            data.append("|").append(rdc.origin().clockDomainUsage().clockDomain().location().markdown(rdc.fullOriginClockDomain())).append("|").append(rdc.target().clockDomainUsage().clockDomain().location().markdown(rdc.fullTargetClockDomain())).append("|").append(((List)rdcsAsMap.get(key)).size()).append("|").append(this.linkToGraph("Open RDCs Graph", "rdcs/rdcs_" + key)).append("|").append(this.linkToDetails("View RDCs Details", "rdcs/rdcs_" + key + ".html")).append("|\n");
        });
        return data.toString();
    }

    private void generateLogicCircuitGraphs() {
        Path bugFinderGraphPath = Path.of(String.valueOf(this.bugfinderWorkDir()) + File.separator + "rdcs", new String[0]);
        if (bugFinderGraphPath.toFile().exists()) {
            if (bugFinderGraphPath.toFile().listFiles() == null) {
                return;
            }
            File rdcsDirectory = new File(String.valueOf(this.graphsDir()) + File.separator + "rdcs");
            rdcsDirectory.mkdirs();
            for (File file : Arrays.stream(bugFinderGraphPath.toFile().listFiles()).filter(f -> f.getName().endsWith("json")).toList()) {
                String fileNameWithoutExtension = file.getName().substring(0, file.getName().length() - 5);
                String id = fileNameWithoutExtension.split("_", 2)[1].replace(";", " => ");
                this.writeGraph(new RDCLogicCircuitGraph(file, "RDC: " + id), fileNameWithoutExtension, "rdcs");
            }
        }
    }
}

