/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl;

import com.google.gson.GsonBuilder;
import com.lintyservices.sonar.plugins.hdl.Graph;
import com.lintyservices.sonar.plugins.hdl.LintyPaths;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public abstract class Report {
    protected static String GRAPH_HTML_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n  <meta charset=\"UTF-8\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n  <style>\n    body {\n      background-color: #1e1e1e;\n    }\n  </style>\n</head>\n\n<body>\n  <linty-viewer href=\"./%s.lintygraph\"></linty-viewer>\n  <script src=\"%s/_static/js/linty-viewer.js\"></script>\n</body>\n\n</html>\n";
    private final Configuration config;
    private final LintyPaths lintyPaths;

    public Report(Configuration config) {
        this.lintyPaths = new LintyPaths(config);
        this.config = config;
    }

    public abstract void generate();

    public abstract String fileName();

    public abstract String title();

    public abstract String summary();

    protected String addBackLinks(String content, String title, String link) {
        String htmlLink = String.format("<a href=\"%s\">%s</a>", (String)(this.urlPath().isEmpty() ? "" : "/" + this.urlPath()) + "/reports/" + link, title);
        return htmlLink + "\n\n<br>\n\n" + content + "\n\n<br>\n\n" + htmlLink;
    }

    protected void writeMainReport(String content, String filename) {
        this.writeFile(content, new File(String.valueOf(this.reportsDir()) + File.separator + filename));
    }

    protected void writeChildReport(String content, String path) {
        this.writeFile(content, new File(String.valueOf(this.reportsDir()) + File.separator + path));
    }

    protected void writeGraph(Graph graph, String fileName) {
        this.writeGraph(graph, fileName, null);
    }

    protected void writeGraph(Graph graph, String fileName, @Nullable String path) {
        String content = String.format(GRAPH_HTML_TEMPLATE, fileName, this.urlPath().isEmpty() ? "" : "/" + this.urlPath());
        String fullPath = String.valueOf(this.graphsDir()) + File.separator;
        if (path != null) {
            fullPath = fullPath + path + File.separator;
        }
        this.writeFile(new GsonBuilder().create().toJson(graph), new File(fullPath + fileName + ".lintygraph"));
        this.writeFile(content, new File(fullPath + fileName + "_graph.html"));
    }

    protected void writeFile(String content, File file) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new LintyException("Cannot generate '" + FileUtils.sanitizedPath(file.getPath()) + "' report", e);
        }
    }

    protected String linkToDetails(String title, String link) {
        Object actualLink = link.startsWith("#") ? link : (String)(this.urlPath().isEmpty() ? "" : "/" + this.urlPath()) + "/reports/" + link;
        return String.format("<a href=\"%s\"><img title=\"%s\" src=\"%s/_static/images/icon_details.png\" style=\"max-height: 25px; width: auto;\" alt=\"%s\"></a>", actualLink, title, this.urlPath().isEmpty() ? "" : "/" + this.urlPath(), title);
    }

    protected String linkToGraph(String title, String name) {
        return String.format("<a href=\"%s/graphs/%s_graph.html\"><img title=\"%s\" src=\"%s/_static/images/icon_graph.png\" style=\"max-height: 25px; width: auto;\" alt=\"%s\"></a>", this.urlPath().isEmpty() ? "" : "/" + this.urlPath(), name, title, this.urlPath().isEmpty() ? "" : "/" + this.urlPath(), title);
    }

    protected String asCheckmark(@Nullable Boolean value) {
        if (value == null) {
            return "Unknown";
        }
        if (value.booleanValue()) {
            return "&#10004;";
        }
        return "&#10007;";
    }

    protected String toLocationMarkdown(Set<YosysFlipFlop> flipFlops) {
        return flipFlops.stream().map(c -> "| " + c.location().markdown() + " |").collect(Collectors.toSet()).stream().sorted().collect(Collectors.joining("\n"));
    }

    protected Configuration config() {
        return this.config;
    }

    protected File reportsDir() {
        return new File(this.lintyPaths.reportDir().getAbsolutePath() + "/reports");
    }

    protected File graphsDir() {
        return new File(this.lintyPaths.reportDir().getAbsolutePath() + "/html/graphs");
    }

    protected File bugfinderWorkDir() {
        return this.lintyPaths.bugfinderWorkDir();
    }

    protected static String sanitizeDescription(@Nullable String description) {
        return description != null ? description : "";
    }

    protected String urlPath() {
        return this.config.get("sonar.hdl.report.urlPath").orElse("").replaceAll("^/+|/+$", "");
    }
}

