/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1014")
public class ClockManagementModuleNamingConventionCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private static final String DEFAULT_FORMAT = "^cmm$";
    @Nullable
    private YosysClockManagementModule clockManagementModule;
    private Set<File> filesToAnalyze;
    @RuleProperty(key="format", description="Regular expression to match for clock management module.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^cmm$")
    public String format = "^cmm$";

    @Override
    public void setClockManagementModule(@Nullable YosysClockManagementModule clockManagementModule) {
        this.clockManagementModule = clockManagementModule;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        if (this.clockManagementModule != null && this.clockManagementModule.isCmm(this.filesToAnalyze) && !pattern.matcher(this.clockManagementModule.moduleName()).matches()) {
            this.issues().addPreciseIssue(this.clockManagementModule.moduleLocation(), String.format("Rename this clock management module to match the following regular expression: %s", this.format));
        }
    }
}

