/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.CombinationalLoopsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderCombinationalLoopsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.combinationalloop.CombinationalLoops;
import com.lintyservices.yosys.objects.YosysCombinationalLoop;
import com.lintyservices.yosys.objects.YosysSignal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1003")
public class CombinationalLoopsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderCombinationalLoopsAwareVisitor {
    private CombinationalLoops combinationalLoops;

    @Override
    public void setCombinationalLoops(CombinationalLoopsInterface combinationalLoopsInterface) {
        this.combinationalLoops = (CombinationalLoops)combinationalLoopsInterface;
    }

    @Override
    public final void retrieveIssues() {
        for (Map.Entry<YosysSignal, List<YosysCombinationalLoop>> loopsBySignal : this.combinationalLoops.combinationalLoops().stream().collect(Collectors.groupingBy(YosysCombinationalLoop::signal)).entrySet()) {
            int numberOfLoops = loopsBySignal.getValue().size();
            String message = String.format("'%s' signal is involved in %d combinational loop%s. Remove the associated loop%s.", loopsBySignal.getKey().name(), numberOfLoops, numberOfLoops > 1 ? "s" : "", numberOfLoops > 1 ? "s" : "");
            this.issues().addPreciseIssue(loopsBySignal.getKey().location(), message);
        }
    }
}

