/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClockDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.clock.ClockDomains;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1041")
public class FallingEdgeTransitionCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderClockDomainsAwareVisitor {
    private ClockDomains domains;

    @Override
    public void setClockDomains(ClockDomainsInterface clockDomains) {
        this.domains = (ClockDomains)clockDomains;
    }

    @Override
    public final void retrieveIssues() {
        Set withRisingEdges = this.domains.clockDomains().stream().filter(YosysClockDomain::rising).collect(Collectors.toSet());
        for (YosysClockDomain domain : withRisingEdges) {
            for (YosysFlipFlop flipFlop : domain.risingFFs()) {
                this.issues().addPreciseIssueWithFlows(flipFlop.location(), String.format("Use falling edge instead%s.", domain.location() != null ? " for clock domain: " + domain.name() : ""), List.of(this.domains.clockAndResetDomainUtils().originLocations(domain)));
            }
        }
    }
}

