/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import java.util.Collection;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1027")
public class FsmMaxNumberOfInputSignalsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private static final int DEFAULT_MAX_NUMBER_OF_SIGNALS = 2;
    private Fsms fsms;
    @RuleProperty(key="max", description="Maximum allowed number of input signals", defaultValue="2")
    public int max = 2;

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            if (fsm.numberOfInputSignals() <= this.max) continue;
            this.issues().addPreciseIssue(fsm.location(), String.format("Simplify this FSM. Actual number of input signals: %d. Maximum allowed number of input signals: %d.", fsm.numberOfInputSignals(), this.max), fsm.inputSignals().stream().flatMap(Collection::stream).collect(Collectors.toSet()).stream().map(s -> new HdlIssueLocation(s.location(), "Input signal: " + s.name())).toList());
        }
    }
}

