/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.RDCsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderRDCsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.RDCs;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.yosys.objects.YosysRDC;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="HDL1022")
public class ListResetDomainCrossingsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderRDCsAwareVisitor {
    private RDCs rdcs;

    @Override
    public void setRDCs(RDCsInterface rdcs) {
        this.rdcs = (RDCs)rdcs;
    }

    @Override
    public final void retrieveIssues() {
        for (YosysRDC rdc : this.rdcs.asList()) {
            String message = String.format("Review reset domain crossing between flip-flop in '%s' clock domain and '%s' reset in '%s' clock domain.", rdc.target().clockDomainUsage().clockDomain().name(), rdc.target().resetDomainUsage().resetDomain().name(), rdc.origin().clockDomainUsage().clockDomain().name());
            HdlIssueLocation primaryLocation = this.rdcs.dcUtils().flipFlopToIssueLocation(rdc.target().location(), "Flip-flop");
            primaryLocation.setMessage(message);
            ArrayList<HdlIssueLocation> reset = new ArrayList<HdlIssueLocation>();
            reset.addAll(this.rdcs.clockAndResetDomainUtils().originLocations(rdc.target().resetDomainUsage().resetDomain()));
            reset.add(this.rdcs.dcUtils().clockDomainUsageToIssueLocation(rdc.origin().clockDomainUsage(), "Reset"));
            ArrayList<HdlIssueLocation> flipFlop = new ArrayList<HdlIssueLocation>();
            flipFlop.add(this.rdcs.dcUtils().clockDomainUsageToIssueLocation(rdc.target().clockDomainUsage(), "Flip-flop"));
            flipFlop.add(this.rdcs.dcUtils().flipFlopToIssueLocation(rdc.target().location(), "Flip-flop location"));
            ArrayList<List<? extends IssueLocationInterface>> flows = new ArrayList<List<? extends IssueLocationInterface>>();
            flows.add(reset);
            flows.add(flipFlop);
            this.issues().addPreciseIssueWithFlows(primaryLocation, flows);
        }
    }
}

