/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.slang.trees.GenericAlwaysBlock;
import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.visitors.GenericAlwaysBlocksAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ProcessTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.ProcessTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysResetDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="HDL1044")
public class MultipleResetUsageInSameProcessOrAlwaysBlockCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor,
ProcessTreeFileAwareVisitor,
GenericAlwaysBlocksAwareVisitor {
    private ResetDomains resetDomains;
    private Set<ProcessTreeFile> processes;
    private Set<GenericAlwaysBlock> alwaysBlocks;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public void setProcesses(Set<ProcessTreeFile> processes) {
        this.processes = processes;
    }

    @Override
    public void setGenericAlwaysBlocks(Set<GenericAlwaysBlock> alwaysBlocks) {
        this.alwaysBlocks = alwaysBlocks;
    }

    @Override
    public final void retrieveIssues() {
        ArrayList<List<? extends IssueLocationInterface>> flows;
        for (Map.Entry<ProcessTreeFile, Set<YosysResetDomain>> entry : this.resetDomainsPerProcess().entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            flows = new ArrayList<List<? extends IssueLocationInterface>>();
            for (YosysResetDomain resetDomain : entry.getValue()) {
                flows.add(this.resetDomains.clockAndResetDomainUtils().originLocations(resetDomain));
            }
            this.issues().addPreciseIssueWithFlows(entry.getKey().file(), ((ProcessStatementTree)entry.getKey().tree()).beginStatementKeyword(), String.format("Split this process to only use one reset domain instead of %d.", entry.getValue().size()), flows);
        }
        for (Map.Entry<Object, Set<YosysResetDomain>> entry : this.resetDomainsPerAlwaysBlock().entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            flows = new ArrayList();
            for (YosysResetDomain resetDomain : entry.getValue()) {
                flows.add(this.resetDomains.clockAndResetDomainUtils().originLocations(resetDomain));
            }
            this.issues().addPreciseIssueWithFlows(((GenericAlwaysBlock)entry.getKey()).keyword().location(), String.format("Split this \"always\" block to only use one reset domain instead of %d.", entry.getValue().size()), flows);
        }
    }

    private Map<ProcessTreeFile, Set<YosysResetDomain>> resetDomainsPerProcess() {
        HashMap<ProcessTreeFile, Set<YosysResetDomain>> resetDomainsPerProcess = new HashMap<ProcessTreeFile, Set<YosysResetDomain>>();
        for (ProcessTreeFile process : this.processes) {
            resetDomainsPerProcess.put(process, new HashSet());
        }
        for (YosysResetDomain resetDomain : this.resetDomains.allResetDomains()) {
            for (YosysFlipFlop flipFlop : resetDomain.usedInFFs()) {
                for (Map.Entry entry : resetDomainsPerProcess.entrySet()) {
                    if (!this.flipFlopGeneratedFromProcess(flipFlop, (ProcessTreeFile)entry.getKey())) continue;
                    ((Set)entry.getValue()).add(resetDomain);
                }
            }
        }
        return resetDomainsPerProcess;
    }

    private boolean flipFlopGeneratedFromProcess(YosysFlipFlop flipFlop, ProcessTreeFile process) {
        return FileUtils.equals(flipFlop.location().file(), process.file()) && flipFlop.location().beginLine() >= ((ProcessStatementTree)process.tree()).line() && flipFlop.location().endLine() <= ((ProcessStatementTree)process.tree()).endLine();
    }

    private Map<GenericAlwaysBlock, Set<YosysResetDomain>> resetDomainsPerAlwaysBlock() {
        HashMap<GenericAlwaysBlock, Set<YosysResetDomain>> resetDomainsPerAlwaysBlock = new HashMap<GenericAlwaysBlock, Set<YosysResetDomain>>();
        for (GenericAlwaysBlock alwaysBlock : this.alwaysBlocks) {
            resetDomainsPerAlwaysBlock.put(alwaysBlock, new HashSet());
        }
        for (YosysResetDomain resetDomain : this.resetDomains.globalResetDomains()) {
            for (YosysFlipFlop flipFlop : resetDomain.usedInFFs()) {
                for (Map.Entry entry : resetDomainsPerAlwaysBlock.entrySet()) {
                    if (!this.flipFlopGeneratedFromAlwaysBlock(flipFlop, (GenericAlwaysBlock)entry.getKey())) continue;
                    ((Set)entry.getValue()).add(resetDomain);
                }
            }
        }
        return resetDomainsPerAlwaysBlock;
    }

    private boolean flipFlopGeneratedFromAlwaysBlock(YosysFlipFlop flipFlop, GenericAlwaysBlock alwaysBlock) {
        return FileUtils.equals(flipFlop.location().file(), alwaysBlock.location().file()) && flipFlop.location().beginLine() >= alwaysBlock.location().line() && flipFlop.location().endLine() <= alwaysBlock.location().endLine();
    }
}

