/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleLocationAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1016")
public class NumberOfResetDomainsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor,
TopModuleLocationAwareVisitor {
    private ResetDomains resetDomains;
    private HdlIssueLocation topModuleLocation;
    private static final int DEFAULT_MAX = 1;
    @RuleProperty(key="max", description="Maximum number of allowed reset domains", type="INTEGER", defaultValue="1")
    private int max = 1;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public void setTopModuleLocation(HdlIssueLocation location) {
        this.topModuleLocation = location;
    }

    @Override
    public final void retrieveIssues() {
        if (this.resetDomains.size() > this.max) {
            this.issues().addPreciseIssueWithFlows(this.topModuleLocation, String.format("Reduce the number of reset domains in this design. Maximum allowed number: %d. Actual number: %d.", this.max, this.resetDomains.size()), this.resetDomains.flows());
        }
    }
}

