/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysResetDomain;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1036")
public class ResetActiveLowCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor {
    private ResetDomains resetDomains;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public final void retrieveIssues() {
        Set withActiveHighResets = this.resetDomains.allResetDomains().stream().filter(YosysResetDomain::activeHigh).collect(Collectors.toSet());
        for (YosysResetDomain domain : withActiveHighResets) {
            for (YosysFlipFlop flipFlop : domain.activeHighFFs()) {
                this.issues().addPreciseIssueWithFlows(flipFlop.location(), String.format("Replace active-high reset with active-low reset%s.", domain.location() != null ? " for reset domain: " + domain.name() : ""), List.of(this.resetDomains.clockAndResetDomainUtils().originLocations(domain)));
            }
        }
    }
}

