/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetDomainsAwareVisitor;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.reset.ResetDomains;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="HDL1018")
public class ResetManagementModuleCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetDomainsAwareVisitor,
BugFinderResetManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private ResetDomains resetDomains;
    @Nullable
    private YosysResetManagementModule resetManagementModule;
    private Set<File> filesToAnalyze;

    @Override
    public void setResetDomains(ResetDomainsInterface resetDomains) {
        this.resetDomains = (ResetDomains)resetDomains;
    }

    @Override
    public void setResetManagementModule(@Nullable YosysResetManagementModule resetManagementModule) {
        this.resetManagementModule = resetManagementModule;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        if (this.resetManagementModule != null && !this.resetManagementModule.isRmm(this.filesToAnalyze)) {
            this.issues().addPreciseIssueWithFlows(this.resetManagementModule.topModule().location(), "All resets should be generated within a unique reset management module.", this.resetDomains.flows());
        }
    }
}

