/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderResetManagementModuleAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1020")
public class ResetManagementModuleNamingConventionCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderResetManagementModuleAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private static final String DEFAULT_FORMAT = "^rmm$";
    @Nullable
    private YosysResetManagementModule resetManagementModule;
    private Set<File> filesToAnalyze;
    @RuleProperty(key="format", description="Regular expression to match for reset management module.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^rmm$")
    public String format = "^rmm$";

    @Override
    public void setResetManagementModule(@Nullable YosysResetManagementModule resetManagementModule) {
        this.resetManagementModule = resetManagementModule;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        if (this.resetManagementModule != null && this.resetManagementModule.isRmm(this.filesToAnalyze) && !pattern.matcher(this.resetManagementModule.moduleName()).matches()) {
            this.issues().addPreciseIssue(this.resetManagementModule.moduleLocation(), String.format("Rename this reset management module to match the following regular expression: %s", this.format));
        }
    }
}

